% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{BloodStorageProstate_df}
\alias{BloodStorageProstate_df}
\title{Effects of Blood Storage on Prostate Cancer Study}
\format{
A data frame with 316 observations and 20 variables:
\describe{
  \item{RBC.Age.Group}{Age group of red blood cells (numeric).}
  \item{Median.RBC.Age}{Median age of red blood cells (numeric).}
  \item{Age}{Patient's age (numeric).}
  \item{AA}{African American status (numeric).}
  \item{FamHx}{Family history of prostate cancer (numeric).}
  \item{PVol}{Prostate volume (numeric).}
  \item{TVol}{Tumor volume (numeric).}
  \item{T.Stage}{Tumor stage (numeric).}
  \item{bGS}{Biopsy grade score (numeric).}
  \item{BN+}{Bone metastasis status (numeric).}
  \item{OrganConfined}{Organ confinement status (numeric).}
  \item{PreopPSA}{Preoperative prostate serum antigen level (numeric).}
  \item{PreopTherapy}{Preoperative therapy received (numeric).}
  \item{Units}{Number of blood transfusion units (numeric).}
  \item{sGS}{Surgical Gleason score (numeric).}
  \item{AnyAdjTherapy}{Any adjuvant therapy received (numeric).}
  \item{AdjRadTherapy}{Adjuvant radiation therapy received (numeric).}
  \item{Recurrence}{Cancer recurrence status (numeric).}
  \item{Censor}{Censoring status (numeric).}
  \item{TimeToRecurrence}{Time to biochemical recurrence in months (numeric).}
}
}
\source{
Data taken from the medicaldata package.
Cata et al. (2011). *Blood Storage Duration and Biochemical Recurrence of Cancer after Radical Prostatectomy*. Mayo Clinic Proceedings, 86(2), 120–127.
}
\usage{
data(BloodStorageProstate_df)
}
\description{
This dataset, BloodStorageProstate_df, is a data frame containing data on 316 men who underwent radical prostatectomy and received a transfusion during or within 30 days of the surgery. The dataset includes demographic, baseline, and prognostic factors, as well as data on the time to biochemical recurrence of prostate cancer, as indicated by prostate serum antigen (PSA) levels.
The main exposure of interest was the red blood cell (RBC) storage duration group, and the outcome of interest was time to PSA cancer recurrence.
}
\details{
The dataset name has been kept as 'BloodStorageProstate_df' to avoid confusion with other datasets in the R ecosystem.
This naming convention helps distinguish this dataset as part of the OncoDataSets package and assists users in identifying
its specific characteristics. The suffix '_df' indicates that the dataset is a data frame. The original content has not been modified in any way.
}
