% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{RotterdamBreastCancer_df}
\alias{RotterdamBreastCancer_df}
\title{Rotterdam Breast Cancer Data}
\format{
A data frame with 2982 observations and 15 variables:
\describe{
  \item{pid}{Patient ID (integer).}
  \item{year}{Year of diagnosis (integer).}
  \item{age}{Age at diagnosis in years (integer).}
  \item{meno}{Menopausal status: 1 = premenopausal, 2 = postmenopausal (integer).}
  \item{size}{Tumor size categorized into three levels (factor).}
  \item{grade}{Tumor grade: 1 = low, 2 = intermediate, 3 = high (integer).}
  \item{nodes}{Number of lymph nodes involved (integer).}
  \item{pgr}{Progesterone receptor status (integer).}
  \item{er}{Estrogen receptor status (integer).}
  \item{hormon}{Hormonal therapy: 1 = yes, 0 = no (integer).}
  \item{chemo}{Chemotherapy: 1 = yes, 0 = no (integer).}
  \item{rtime}{Time to recurrence in days (numeric).}
  \item{recur}{Recurrence status: 1 = recurrence, 0 = no recurrence (integer).}
  \item{dtime}{Time to death in days (numeric).}
  \item{death}{Death status: 1 = deceased, 0 = alive (integer).}
}
}
\source{
Data taken from the survival package.
Based on records from the Rotterdam tumor bank and used in Royston and Altman (2013) for survival analysis.
}
\usage{
data(RotterdamBreastCancer_df)
}
\description{
This dataset, RotterdamBreastCancer_df, is a data frame containing data on 2982 patients with primary breast cancer. The data was collected as part of the Rotterdam tumor bank and was used in Royston and Altman (2013) for survival analysis and prognostic model evaluation.
}
\details{
The dataset name has been kept as 'RotterdamBreastCancer_df' to avoid confusion with other datasets in the R ecosystem.
This naming convention helps distinguish this dataset as part of the OncoDataSets package and assists users in identifying
its specific characteristics. The suffix '_df' indicates that the dataset is a data frame. The original content has not been modified in any way.
}
