% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{WBreastCancer_tbl_df}
\alias{WBreastCancer_tbl_df}
\title{Women with Breast Cancer Study}
\format{
A tibble with 1207 observations and 9 variables:
\describe{
  \item{id}{Unique identifier for each patient (numeric).}
  \item{time}{Time to the event or censoring (numeric).}
  \item{status}{Event status: 1 if the event occurred, 0 if censored (numeric).}
  \item{er}{Estrogen receptor status (numeric).}
  \item{age}{Age of the patient at the time of diagnosis (numeric).}
  \item{histgrad}{Histological grade of the tumor (numeric).}
  \item{ln_yesno}{Presence of lymph nodes: 1 if positive, 0 if negative (numeric).}
  \item{pathsd}{Pathological stage of the disease (numeric).}
  \item{pr}{Progesterone receptor status (numeric).}
}
}
\source{
Data taken from the psfmi package.
}
\usage{
data(WBreastCancer_tbl_df)
}
\description{
This dataset, WBreastCancer_tbl_df, is a tibble containing data from a study among
women with breast cancer. The dataset includes clinical and demographic variables
for 1207 patients, providing valuable insights for breast cancer research and analysis.
}
\details{
The dataset name has been kept as 'WBreastCancer_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
OncoDataSets package and assists users in identifying its specific characteristics.
The original content has not been modified in any way.
}
