% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpenRange_species.R
\name{OpenRange_species}
\alias{OpenRange_species}
\title{Download range maps for given species.}
\usage{
OpenRange_species(
  species,
  directory,
  default_only = TRUE,
  matched = TRUE,
  match_names_only = FALSE,
  include_id = TRUE,
  projection = 4326,
  scenario = "present",
  ...
)
}
\arguments{
\item{species}{A single species or a vector of species.}

\item{directory}{Directory that range maps should be saved in.}

\item{default_only}{Logical. Should only default ranges be included? Default is TRUE.}

\item{matched}{Return a list of taxa that were downloaded. Default is TRUE.}

\item{match_names_only}{Check for range maps for the taxa specified without downloading range maps. Default is FALSE.}

\item{include_id}{Logical. Should the range_id be appended to the file name?  Needed to save multiple maps per species.}

\item{projection}{Numeric. What projection should maps be returned in?  4326 (default) or 3857}

\item{scenario}{Which climate scenario should be represented by maps?  See BIEN_ranges_list_scenarios.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
Range maps for specified species.
}
\description{
OpenRange_species extracts range maps for the specified species.
}
\note{
Details on the construction of BIEN range maps is available at http://bien.nceas.ucsb.edu/bien/biendata/bien-3/
}
\examples{
\donttest{

library(maps) #a convenient source of maps
library(sf)

species_vector <- c("Abies_lasiocarpa","Abies_amabilis")

#check whether the species are available
OpenRange_species(species_vector,match_names_only = TRUE)

#Create a temp directory
temp_dir <- file.path(tempdir(), "BIEN_temp")

#Download ranges
OpenRange_species(species = species_vector,
                 directory = temp_dir)#saves ranges to a temporary directory

#Reading files

Abies_poly <- st_read(dsn = temp_dir,
                     layer = "Abies_amabilis_117684")

#Plotting files
plot(Abies_poly[,1])#plots the range, but doesn't mean much without any reference
map('world', fill = TRUE, col = "grey")#plots a world map (WGS84 projection), in grey
plot(Abies_poly,col="forest green",add=TRUE) #adds the range of Abies lasiocarpa to the map

#Getting data from the files
Abies_poly |>
 st_drop_geometry()

}
}
\seealso{
Other range functions: 
\code{\link{OpenRange_api_load_species}()},
\code{\link{OpenRange_api_species}()},
\code{\link{OpenRange_get_license}()},
\code{\link{OpenRange_get_stats}()},
\code{\link{OpenRange_list_scenarios}()},
\code{\link{OpenRange_load_species}()},
\code{\link{OpenRange_sf}()}
}
\concept{range functions}
