% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PERSUADE_function.R
\name{f_hazard}
\alias{f_hazard}
\title{Calculate Smoothed Hazard Estimates}
\usage{
f_hazard(years, status, group, ngroups)
}
\arguments{
\item{years}{Numeric vector of time-to-event data.}

\item{status}{Numeric vector indicating event occurrence (1 = event, 0 = censoring).}

\item{group}{Factor indicating group membership.}

\item{ngroups}{Integer. Number of groups (1-3).}
}
\value{
A list with elements:
\itemize{
\item \code{hazards}: List of hazard objects (one per group).
\item \code{names}: Vector of group identifiers for hazard values.
\item \code{max}: Data frame with maximum time and hazard values.
}
}
\description{
Computes smoothed hazard estimates for up to three groups using
the \pkg{muhaz} package.
}
\examples{
years <- survival::lung$time
status <-  survival::lung$status
group <- factor(survival::lung$sex)
f_hazard(
  years = years,
  status = status,
  group = group,
  ngroups = nlevels(group)
)

}
