% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/half.life.R
\name{get_halflife_points}
\alias{get_halflife_points}
\title{Determine which concentrations were used for half-life calculation}
\usage{
get_halflife_points(object)
}
\arguments{
\item{object}{A PKNCAresults object}
}
\value{
A logical vector with \code{TRUE} if the point was used for half-life
(including concentrations below the limit of quantification within the
range of times for calculation), \code{FALSE} if it was not used for half-life
but the half-life was calculated for the interval, and \code{NA} if half-life
was not calculated for the interval. If a row is excluded from all
calculations, it is set to \code{NA} as well.
}
\description{
Determine which concentrations were used for half-life calculation
}
\examples{
o_conc <- PKNCAconc(Theoph, conc~Time|Subject)
o_data <- PKNCAdata(o_conc, intervals = data.frame(start = 0, end = Inf, half.life = TRUE))
o_nca <- pk.nca(o_data)
get_halflife_points(o_nca)
}
