% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk.calc.simple.R
\name{pk.calc.cmax}
\alias{pk.calc.cmax}
\alias{pk.calc.cmin}
\title{Determine maximum observed PK concentration}
\usage{
pk.calc.cmax(conc, check = TRUE)

pk.calc.cmin(conc, check = TRUE)
}
\arguments{
\item{conc}{Measured concentrations}

\item{check}{Run \code{\link[=assert_conc]{assert_conc()}}?}
}
\value{
a number for the maximum concentration or NA if all concentrations
are missing
}
\description{
Determine maximum observed PK concentration
}
\section{Functions}{
\itemize{
\item \code{pk.calc.cmin()}: Determine the minimum observed PK
concentration

}}
\examples{
conc_data <- Theoph[Theoph$Subject == 1,]
pk.calc.cmin(conc_data$conc)
}
\seealso{
Other NCA parameters for concentrations during the intervals: 
\code{\link{pk.calc.clast.obs}()},
\code{\link{pk.calc.count_conc}()},
\code{\link{pk.calc.cstart}()},
\code{\link{pk.calc.ctrough}()}

Other NCA parameters for concentrations during the intervals: 
\code{\link{pk.calc.clast.obs}()},
\code{\link{pk.calc.count_conc}()},
\code{\link{pk.calc.cstart}()},
\code{\link{pk.calc.ctrough}()}
}
\concept{NCA parameters for concentrations during the intervals}
