% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likPOUMM.R
\name{likPOUMMGivenTreeVTipsC}
\alias{likPOUMMGivenTreeVTipsC}
\title{Fast (parallel) POUMM likelihood calculation using the SPLITT 
library}
\usage{
likPOUMMGivenTreeVTipsC(
  integrator,
  alpha,
  theta,
  sigma,
  sigmae,
  g0 = NA,
  g0Prior = NULL,
  log = TRUE
)
}
\arguments{
\item{integrator}{An Rcpp module object from the class POUMM_AbcPOUMM. This 
object is to be created using the function pruneTree (see example). 
This object contains the data and tree (arguments z and tree of the 
equivalent function dVTipsGivenTreeVTips.).}

\item{alpha}{the strength of the selection}

\item{theta}{long term mean value of the OU process}

\item{sigma}{the unit-time standard deviation of the random component in the
OU process.}

\item{sigmae}{the standard deviation of the environmental deviation added to
the genetic contribution at each tip, by default 0, meaning no
environmental deviation.}

\item{g0}{Numeric, NA or NaN, either a fixed genotypic value at the root of 
tree or NA or NaN. A NA "Not Available" will cause to analytically
calculate the value of g0 that would maximize the conditional likelihood of
the data given g0. A NaN "Not a Number" will cause integration over g0
taking values in (-Inf,+Inf) assuming that g0 is normally distributed with
mean g0Prior$mean and variance g0Prior$var (see parameter g0Prior).}

\item{g0Prior}{Either NULL or a list with named numeric or character members
"mean" and "var". Specifies a prior normal distribution for the parameter
 g0.
If characters, the members mean and var are evaluated as R-expressions.}

\item{log}{Logical indicating whether log-likelihood should be returned
instead of likelihood, default is TRUE.}
}
\value{
A numeric with attributes "g0" and "g0LogPrior".
}
\description{
Fast (log-)likelihood calculation using C++
 and OpenMP based parallelization.
}
\details{
This function is the C++ equivalent of dVTipsGivenTreePOUMM
 (aliased also as likPOUMMGivenTreeVTips). Currently, the function does not 
 support multiple precision floating point operations (supported in 
 dVTipsGivenTreePOUMM). The C++ implementation is based on the library for
 parallel tree traversal "SPLITT" 
 (https://github.com/venelin/SPLITT.git).
}
\examples{
\dontrun{
N <- 100
tr <- ape::rtree(N)
z <- rVNodesGivenTreePOUMM(tr, 0, 2, 3, 1, 1)[1:N]
pruneInfo <- pruneTree(tr, z)
microbenchmark::microbenchmark(
  likCpp <- likPOUMMGivenTreeVTipsC(pruneInfo$integrator, 2, 3, 1, 1),
  likR <- likPOUMMGivenTreeVTips(z, tr, 2, 3, 1, 1, pruneInfo = pruneInfo))

# should be the same values
likCpp
likR
}

}
\references{
Mitov, V., and Stadler, T. (2017). Fast and Robust Inference of Phylogenetic Ornstein-Uhlenbeck Models Using Parallel Likelihood Calculation. bioRxiv, 115089. 
 https://doi.org/10.1101/115089
 Mitov, V., & Stadler, T. (2017). Fast Bayesian Inference of Phylogenetic Models Using Parallel Likelihood Calculation and Adaptive Metropolis Sampling. Systematic Biology, 235739. http://doi.org/10.1101/235739
}
\seealso{
dVTipsGivenTreePOUMM
}
