% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/U03-weights.R
\name{calculate_ipw_weights}
\alias{calculate_ipw_weights}
\title{Propensity Score Weighting for PSsurvival Package}
\usage{
calculate_ipw_weights(
  ps_result,
  data,
  treatment_var,
  estimand = "ATE",
  att_group = NULL
)
}
\arguments{
\item{ps_result}{A list returned by \code{estimate_ps()}, containing:
\itemize{
  \item ps_matrix: Matrix of propensity scores (n x J) for multiple treatments,
    or NULL for binary treatment
  \item ps: Vector of propensity scores for observed treatment
  \item n_levels: Number of treatment levels
  \item treatment_levels: Vector of treatment level values
}}

\item{data}{A data.frame containing the treatment variable.}

\item{treatment_var}{A character string specifying the name of the treatment
variable in \code{data}.}

\item{estimand}{Character string specifying the estimand. One of "ATE" (default)
or "ATT" (Average Treatment Effect on the Treated).}

\item{att_group}{For ATT estimation, specifies which treatment group to target.
This is MANDATORY when estimand = "ATT".}
}
\value{
A numeric vector of IPW weights with length equal to nrow(data).
}
\description{
Functions for calculating propensity score weights with optional trimming
for binary and multiple treatment groups.
Calculate Inverse Probability Weights (IPW)

Calculates inverse probability weights for binary or multiple treatment groups.
For ATE (Average Treatment Effect), weights are 1/e_j(X) for each treatment j.
For ATT (Average Treatment Effect on the Treated), weights target a specific
treatment group.
}
\details{
For ATE with multiple treatments, weights are:
\deqn{w_j(X_i) = \frac{1}{e_j(X_i)} \text{ for individual i in treatment j}}

For ATT targeting treatment k, weights are:
\deqn{w_j(X_i) = \begin{cases}
  1 & \text{if } j = k \\
  \frac{e_k(X_i)}{e_j(X_i)} & \text{if } j \neq k
\end{cases}}
}
\keyword{internal}
