% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{summary}
\alias{summary}
\alias{summary.ptsr}
\alias{print.summary.ptsr}
\title{Summary Method of class PTSR}
\usage{
\method{summary}{ptsr}(object, ...)

\method{print}{summary.ptsr}(x, digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"), ...)
}
\arguments{
\item{object}{object of class \code{"ptsr"}.}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class \code{"summary.ptsr"},
usually, a result of a call to \code{summary.ptsr}.}

\item{digits}{minimal number of significant digits, see
\code{\link{print.default}}.}

\item{signif.stars}{logical. If \code{TRUE},
\sQuote{significance stars} are printed for each coefficient.}
}
\value{
The function \code{summary.ptsr} computes and returns a list
of summary statistics of the fitted model given in \code{object}.
Returns a list of class \code{summary.ptsr}, which contains the
following components:

\item{residuals}{the residuals of the model.}

\item{coefficients}{a \eqn{k \times 4}{k x 4} matrix with columns for
the estimated coefficient, its standard error, z-statistic and corresponding
(two-sided) p-value.}

\item{sigma.res}{the square root of the estimated variance of the random
error \deqn{\hat\sigma^2 = \frac{1}{n-k}\sum_i{r_i^2},}{\sigma^2 = \frac{1}{n-k} \sum_i r[i]^2,}
where \eqn{r_i}{r[i]} is the \eqn{i}-th residual, \code{residuals[i]}.}

\item{df}{degrees of freedom, a 3-vector \eqn{(k, n-k, k*)}, the first
being the number of non-aliased coefficients, the last being the total
number of coefficients.}

\item{vcov}{a \eqn{k \times k}{k \times k} matrix of (unscaled) covariances.
The inverse ov the information matrix.}

\item{loglik}{the sum of the log-likelihood values}

\item{aic}{the AIC value. \eqn{AIC = -2*loglik+2*k}.}

\item{bic}{the BIC value. \eqn{BIC = -2*loglik + log(n)*k}.}

\item{hqc}{the HQC value. \eqn{HQC = -2*loglik + log(log(n))*k}.}
}
\description{
\code{summary} method for class \code{"ptsr"}.
}
\details{
\code{print.summary.btsr} tries to be smart about formatting the
coefficients, standard errors, etc. and additionally provides
\sQuote{significance stars}.
}
