% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omics_array.R
\name{probeMerge,omics_array-method}
\alias{probeMerge,omics_array-method}
\alias{probeMerge}
\title{Function to merge probesets}
\usage{
\S4method{probeMerge}{omics_array}(x, ...)
}
\arguments{
\item{x}{omicsarray}

\item{\dots}{Additionnal parameters to the collapseRows function of the
WGCNA package}
}
\value{
Formal class 'omics_array' [package "Patterns"] with 7 slots
}
\description{
Used to collapse probesets using the collapseRows function of the WGCNA
package
}
\examples{

data(jetsetscores)
if(require(CascadeData)){
data(micro_S)
D<-as.omics_array(micro_S[1:400,],1:4,6)
D@gene_ID<-jetsetscores[D@name,"EntrezID"]
PM <- probeMerge(D)
}

}
\author{
Bertrand Frederic, Myriam Maumy-Bertrand.
}
\keyword{manip}
