% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreynorRatio.R
\name{TreynorRatio}
\alias{TreynorRatio}
\title{calculate Treynor Ratio or modified Treynor Ratio of excess return over CAPM beta}
\usage{
TreynorRatio(Ra, Rb, Rf = 0, scale = NA, modified = FALSE)
}
\arguments{
\item{Ra}{an xts, vector, matrix, data frame, timeSeries or zoo object of
asset returns}

\item{Rb}{return vector of the benchmark asset}

\item{Rf}{risk free rate, in same period as your returns}

\item{scale}{number of periods in a year (daily scale = 252, monthly scale =
12, quarterly scale = 4)}

\item{modified}{a boolean to decide whether to return the Treynor ratio or
Modified Treynor ratio}
}
\description{
The Treynor ratio is similar to the Sharpe Ratio, except it uses beta as the
volatility measure (to divide the investment's excess return over the beta).
}
\details{
To calculate modified Treynor ratio, we divide the numerator by the systematic risk
instead of the beta.

Equation:
\deqn{TreynorRatio = \frac{\overline{(R_{a}-R_{f})}}{\beta_{a,b}}}{(mean(Ra-Rf))/(Beta(Ra,Rb))}
\deqn{ModifiedTreynorRatio = \frac{r_p - r_f}{\sigma_s}}{ModifiedTreynorRatio = (Rp - Rf)/sytematic risk}
}
\examples{

data(portfolio_bacon) 
data(managers)
round(TreynorRatio(managers[,1], managers[,8], Rf=.035/12),4) 
round(TreynorRatio(managers[,1], managers[,8], Rf = managers[,10]),4) 
round(TreynorRatio(managers[,1:6], managers[,8], Rf=.035/12),4) 
round(TreynorRatio(managers[,1:6], managers[,8], Rf = managers[,10]),4)
round(TreynorRatio(managers[,1:6], managers[,8:7], Rf=.035/12),4) 
round(TreynorRatio(managers[,1:6], managers[,8:7], Rf = managers[,10]),4)

print(TreynorRatio(portfolio_bacon[,1], portfolio_bacon[,2], modified = TRUE)) #expected 0.7975 

print(TreynorRatio(managers['2002',1], managers['2002',8], modified = TRUE))
print(TreynorRatio(managers['2002',1:5], managers['2002',8], modified = TRUE)) 

}
\references{
\url{https://en.wikipedia.org/wiki/Treynor_ratio}, 
Carl Bacon, \emph{Practical portfolio performance measurement 
and attribution}, second edition 2008 p.77
}
\seealso{
\code{\link{SharpeRatio}} \code{\link{SortinoRatio}}
\code{\link{CAPM.beta}}
}
\author{
Peter Carl, Matthieu Lestel
}
