% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to.period.contributions.R
\name{to.period.contributions}
\alias{to.period.contributions}
\alias{to.monthly.contributions}
\alias{to.weekly.contributions}
\alias{to.quarterly.contributions}
\alias{to.yearly.contributions}
\title{Aggregate contributions through time}
\usage{
to.period.contributions(
  Contributions,
  period = c("years", "quarters", "months", "weeks", "all")
)
}
\arguments{
\item{Contributions}{a time series of the per period contribution to portfolio return of each asset}

\item{period}{period to convert to.  See details. "weeks", "months", "quarters", "years", or "all".}
}
\description{
Higher frequency contributions provided as a time series are converted to a lower
frequency for a specified calendar period.
}
\details{
From the portfolio contributions of individual assets, such as those of a particular asset class
or manager, the multiperiod contribution is neither summable from nor the geometric compounding of
single-period contributions.  Because the weights of the individual assets change through time as
transactions occur, the capital base for the asset changes.

Instead, the asset's multiperiod contribution is the sum of the asset's dollar contributions from
each period, as calculated from the wealth index of the total portfolio. Once contributions are
expressed in cumulative terms, asset contributions then sum to the returns of the total portfolio for
the period.

Valid period character strings for period include: "weeks", "months", "quarters", "years", or "all".
These are calculated internally via \code{\link[xts]{endpoints}}. See that function's help page for further details.

For the special period "all", the contribution is calculated over all rows,
giving a single contribution across all observations.
}
\examples{
data(managers, package="PerformanceAnalytics")

res_qtr_rebal = Return.portfolio(  managers["2002::",1:5]
                                 , weights=c(.05,.1,.3,.4,.15)
                                 , rebalance_on = "quarters"
                                 , verbose=TRUE)
                                 
to.period.contributions(res_qtr_rebal$contribution, period="years")
to.yearly.contributions(res_qtr_rebal$contribution)

}
\references{
Morningstar, \emph{Total Portfolio Performance Attribution Methodology}, p.36.
  Available at
  \url{https://corporate.morningstar.com/US/documents/MethodologyDocuments/MethodologyPapers/TotalPortfolioPerformanceAttributionMethodology.pdf}
}
\seealso{
\code{\link{Return.portfolio}} \cr \code{\link[xts]{endpoints}} \cr
}
\author{
Peter Carl, with thanks to Paolo Cavatore
}
