% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_report.R
\name{pp_report}
\alias{pp_report}
\title{Produce a report of policy portfolios}
\usage{
pp_report(
  D,
  id = NULL,
  file = NULL,
  title = NULL,
  plot = c("single", "comparative"),
  text = TRUE,
  width = 12,
  height = 7,
  comparative = c("temporal", "static"),
  between = "",
  within = "",
  dev_type_html = "svg",
  ...
)
}
\arguments{
\item{D}{Data frame in a tidy format with the following columns: "Country", "Sector", "Year", "Instrument", "Target" and "covered". "covered" is a binary identificator of whether the portfolio space is covered by policy intervention (1) or not (0). The remaining columns identify the case. Notice that "Year" is a numeric value, while the remaining 4 case identifiers are factors.}

\item{id}{A list with up to two elements, namely "Country", and "Year" indicating the specific identification characteristics of the portfolio(s) that must be processed. Defaults to NULL to process all portfolios.}

\item{file}{Character vector with the name of the file to create. Defaults to a combination of the date and time of production and policy portfolio report.}

\item{title}{A character vector with the title of the report. If no title is passed, the default (NULL) is to use the id, or a generic title with the date and time of its production.}

\item{plot}{A character vector with the types of plot to perform. If no plot is desired, set it to NULL. By default it plots individual portfolios ("single") as well as comparative figures with portfolio measures ("comparative").}

\item{text}{A logical vector of whether in the case of single portfolios a textual report should be included.}

\item{width}{A number with the width of the device for individual portfolio figures. Defaults to 12 for the svg device.}

\item{height}{A number with the width of the device for individual portfolio figures. Defaults to 7 for the svg device.}

\item{comparative}{A character vector with the types of comparative plots to perform. If no comparative plot is desired, set it to NULL. Valid types of comparative plots are "temporal" (for showing time series of measures of portfolios) or "static" (for dotplots with the values of a single time period. If multiple years are passed and "static" is set, then the last year is used.}

\item{between}{A character vector indicating the variable to which the between-comparison must be performed. Defaults to "Sector". Not yet implemented.}

\item{within}{A character vector indicating the variable to which the between-comparison must be performed. Defaults to "Country". Not yet implemented.}

\item{dev_type_html}{Character. Character vector indicating the type of graphical device for the html output. By default, svg. See RMarkdown.}

\item{...}{Other options passed to intermediate functions.}
}
\value{
An html report.
}
\description{
Produce a report of policy portfolios.
}
\examples{
\dontrun{
data(P.education)
pp_report(P.education)

pp_report(P.education, id = list(Country = "Borduria", Year = 2025))
}
}
