% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addschool.R
\name{addschool}
\alias{addschool}
\title{Match school children to schools}
\usage{
addschool(
  people,
  pplid,
  pplage,
  pplsx,
  pplst = NULL,
  hhid = NULL,
  schools,
  schid,
  schage,
  schroll,
  schtype,
  schmiss = 0,
  sameprob = 1,
  userseed = NULL
)
}
\arguments{
\item{people}{A data frame containing individual people.}

\item{pplid}{The variable containing the unique identifier for each person, in the people data frame.}

\item{pplage}{The variable containing the ages, in the people data frame.}

\item{pplsx}{The variable containing the codes for sex, in the people data frame.}

\item{pplst}{The school status variable in the people data frame. Only two numeric values/factor levels can be used. The smallest number/level is the code for people not in school.}

\item{hhid}{The household identifier variable, in the people data frame.}

\item{schools}{A data frame containing the schools.}

\item{schid}{The variable containing the unique identifier for each school, in the schools data frame.}

\item{schage}{The variable containing the ages, in the schools data frame.}

\item{schroll}{The variable containing the number of places available for people at that school age, within the school.}

\item{schtype}{The variable that indicates whether the school is co-educational or single-sex. The expected value for a co-educational school is "C". The codes for female and male must be the same as in the people data frame.}

\item{schmiss}{The school identifier value that will be given to those people not in school. If left blank, the default value is 0. If the school IDs are numeric in the schools data frame, a numeric missing value must be supplied.}

\item{sameprob}{The probability that students from the same household will be at the same school, given age (and sex if there are same-sex schools). Results depend on the number of students in each household, and student ages, combined with the sizes of the school rolls. Value must be between 0 and 1. The default value is 1.}

\item{userseed}{If specified, this will set the seed to the number provided. If not,the normal set.seed() function will be used.}
}
\value{
Two data frames, as a list. $Population contains the synthetic population with the schools added. $Schools contains the remaining roll counts for the schools.
}
\description{
Creates a data frame of people and matching schools. By default, all similarly-aged students in the same household will be matched to the same school. If one student is matched to a same-sex school, then all similarly aged students will also be matched to a same-sex school. This includes opposite-sex children, with boys attending a same-sex boys school, and girls attending a same-sex girls school.
Two data frames are required: one for the people ("people) and one for the schools ("schools").
In the "people" data frame, a numeric or ordered factor for school status is required. The smallest value/level will be treated as the code for non-students. If one value is used, everyone in the data frame will be allocated a school. Thus, pre-cleaning a data frame is not required.
The "schools" data frame must be a summary in the form of roll counts by age within school. Each row is one age only. For example, if a school has children aged 5 to 9 years, there should be 5 rows. Any combination of co-educational and single-sex schools can be used,  and the relevant value must be on each row of the schools" data frame.
}
\examples{

library(dplyr)

# children in the same household will be added to the same school, if possible with a .8 probability
\donttest{SchoolsAdded <- addschool(IntoSchools, pplid = "ID", pplage = "Age", pplsx = "SexCode",
                          pplst = "SchoolStatus", hhid = "HouseholdID", SchoolsToUse,
                          schid = "School.Name", schage = "AgeInRoll", schroll = "RollCount",
                          schtype = "Gender", schmiss = 0, sameprob = .8, userseed = 4)

Population <- SchoolsAdded$Population
Schools <- SchoolsAdded$Schools}
}
