% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agedis.R
\name{agedis}
\alias{agedis}
\title{Add a sex/age structure to a data frame of grouped ages}
\usage{
agedis(
  individuals,
  indsx,
  minage,
  maxage,
  pyramid,
  pyrsx,
  pyrage,
  pyrcount,
  agevarname,
  userseed = NULL
)
}
\arguments{
\item{individuals}{A data frame containing observations with grouped ages. These are the observations to which the sex/age pyramid is applied.}

\item{indsx}{The variable containing the codes for sex, in the individuals data frame.}

\item{minage}{The variable containing the minimum age for the age group, in the individuals data frame.}

\item{maxage}{The variable containing the maximum age for the age group, in the individuals data frame.}

\item{pyramid}{A data frame containing the sex/age pyramid to be used.}

\item{pyrsx}{The variable containing the codes for sex, in the pyramid data frame.}

\item{pyrage}{The variable containing the ages, in the pyramid data frame.}

\item{pyrcount}{The variable containing the counts for each sex/age combination, in the pyramid data frame.}

\item{agevarname}{The name to use for the constructed age variable in the output data frame. For each row, this will contain one integer.}

\item{userseed}{The user-defined seed for reproducibility. If left blank the normal set.seed() function will be used.}
}
\value{
A data frame of an observations, with an added column that contains the age.
}
\description{
Adds an age variable to a data frame that contains age groups, based on age group within sex.
Two data frames are required: the data frame that contains individuals with age bands ("individuals"), and a data frame used as the basis for constructing a sex/age pyramid ("pyramid").
The individuals data frame requires two columns relating to the age groups. One is the minimum age in the age group. The second is the maximum age in the age group. For example, the age group 0 - 4 years would have 0 as the minimum age value and 4 as the maximum age value. Each person in the individuals data frame must have both the minimum and maximum age variables populated.
The pyramid data frame must contain counts by sex/age in the population of interest.
The variables specifying sex can be numeric, character, or factor. The sole requirement is that the codes must match.  For example, if "F" and "M" are used in the individuals data frame to denote sex, then "F" and "M" are the codes required in the pyramid data frame. Any number of sex code values can be used, so long as they are unique.
}
\examples{

library("dplyr")

ReducedDF <- InitialDataframe \%>\%
  slice_sample(n=200, replace = FALSE)
DisaggregateAge <- agedis(ReducedDF, indsx = "Sex", minage = "LowerAge", maxage = "UpperAge",
                          pyramid = SingleAges, pyrsx = "Sex", pyrage = "Age", pyrcount = "Value",
                          agevarname = "TheAge", userseed = 4)
}
