% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bestMatchListFunctions.R
\name{classifSumm}
\alias{classifSumm}
\title{Summarizes pattern-matching results}
\usage{
classifSumm(pileup, bestMatchList, windowSize, mode, chunkSize)
}
\arguments{
\item{pileup}{A .txt file containing mapped sequencing read coverages averaged over
100 bp windows/bins.}

\item{bestMatchList}{A list containing pattern-match information associated with
all contigs/chunks classified by `ProActive()` pattern-matching}

\item{windowSize}{The number of basepairs to average read coverage values over.
Options are 100, 200, 500, 1000 ONLY. Default is 1000.}

\item{mode}{Either "genome" or "metagenome"}

\item{chunkSize}{If `mode`="genome" OR if `mode`="metagenome" and `chunkContigs`=TRUE,
chunk the genome or contigs, respectively, into smaller subsets for pattern-matching.}
}
\description{
Summarizes the list of pattern-matching classifications into a table.
}
\keyword{internal}
