% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhl_data.R
\name{nhl_data_espn}
\alias{nhl_data_espn}
\title{NHL Data ESPN}
\format{
A \code{tibble} with the following columns:
\describe{
  \item{\code{name}}{The name of the player.}
  \item{\code{year}}{The year of the draft.}
  \item{\code{date_of_birth}}{The date of birth of the player.}
  \item{\code{age}}{The age of the player at the time of the draft.}
  \item{\code{current_team}}{The current team of the player.}
  \item{\code{league}}{The league the player was playing in before the draft.}
  \item{\code{scouting_report}}{A scouting report of the player.}
  \item{\code{team_fit}}{How well the player fits with the drafting team.}
  \item{\code{likely_to_play}}{The likelihood of the player playing in the NHL.}
}
}
\usage{
nhl_data_espn()
}
\value{
A filtered and selected tibble of NHL data from ESPN.
}
\description{
Filter NHL Data by Source (ESPN)
}
\details{
Filters and selects NHL data from ESPN for the given source value.
}
\examples{
# Filter NHL data for ESPN
espn_data <- nhl_data_espn()

# View the first few rows
head(espn_data)

}
