% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-basic.R
\name{plot_network}
\alias{plot_network}
\title{Visualize a (partial correlation) network graph of words.}
\usage{
plot_network(
  data,
  words = NULL,
  pattern = NULL,
  index = c("pcor", "cor", "glasso", "sim"),
  alpha = 0.05,
  bonf = FALSE,
  max = NULL,
  node.size = "auto",
  node.group = NULL,
  node.color = NULL,
  label.text = NULL,
  label.size = 1.2,
  label.size.equal = TRUE,
  label.color = "black",
  edge.color = c("#009900", "#BF0000"),
  edge.label = FALSE,
  edge.label.size = 1,
  edge.label.color = NULL,
  edge.label.bg = "white",
  file = NULL,
  width = 10,
  height = 6,
  dpi = 500,
  ...
)
}
\arguments{
\item{data}{A \code{\link[=as_wordvec]{wordvec}} (data.table) or \code{\link[=as_embed]{embed}} (matrix), see \code{\link[=data_wordvec_load]{data_wordvec_load()}}.}

\item{words}{[Option 1] Character string(s).}

\item{pattern}{[Option 2] \link[stringr:str_subset]{Regular expression}. If \code{words} and \code{pattern} are not specified, all words in the data will be extracted.}

\item{index}{Use which index to perform network analysis?
\itemize{
\item \code{"pcor"}: partial correlation (default and suggested)
\item \code{"cor"}: raw correlation
\item \code{"glasso"}: graphical lasso-estimation of partial correlation matrix (using the \code{glasso} package)
\item \code{"sim"}: pairwise cosine similarity
}}

\item{alpha}{Significance level to be used for not showing edges. Defaults to \code{0.05}.}

\item{bonf}{Bonferroni correction of \emph{p} value. Defaults to \code{FALSE}.}

\item{max}{Maximum value for scaling edge widths and colors. Defaults to the highest value of the index. Can be \code{1} if you want to compare several graphs.}

\item{node.size}{Node size. Defaults to \code{8*exp(-nNodes/80)+1}.}

\item{node.group}{Node group(s). Can be a named list (see examples) in which each element is a vector of integers identifying the numbers of the nodes that belong together, or a factor.}

\item{node.color}{Node color(s). Can be a character vector of colors corresponding to \code{node.group}. Defaults to white (if \code{node.group} is not specified) or the palette of ggplot2 (if \code{node.group} is specified).}

\item{label.text}{Node label of text. Defaults to original words.}

\item{label.size}{Node label font size. Defaults to \code{1.2}.}

\item{label.size.equal}{Make the font size of all labels equal. Defaults to \code{TRUE}.}

\item{label.color}{Node label color. Defaults to \code{"black"}.}

\item{edge.color}{Edge colors for positive and negative values, respectively. Defaults to \code{c("#009900", "#BF0000")}.}

\item{edge.label}{Edge label of values. Defaults to \code{FALSE}.}

\item{edge.label.size}{Edge label font size. Defaults to \code{1}.}

\item{edge.label.color}{Edge label color. Defaults to \code{edge.color}.}

\item{edge.label.bg}{Edge label background color. Defaults to \code{"white"}.}

\item{file}{File name to be saved, should be png or pdf.}

\item{width, height}{Width and height (in inches) for the saved file. Defaults to \code{10} and \code{6}.}

\item{dpi}{Dots per inch. Defaults to \code{500} (i.e., file resolution: 4000 * 3000).}

\item{...}{Arguments passed on to \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}
}
\value{
Invisibly return a \code{\link[qgraph:qgraph]{qgraph}} object, which further can be plotted using \code{plot()}.
}
\description{
Visualize a (partial correlation) network graph of words.
}
\section{Download}{

Download pre-trained word vectors data (\code{.RData}): \url{https://psychbruce.github.io/WordVector_RData.pdf}
}

\examples{
\donttest{d = as_embed(demodata, normalize=TRUE)

words = cc("
man, woman,
he, she,
boy, girl,
father, mother,
mom, dad,
China, Japan
")

plot_network(d, words)

p = plot_network(
  d, words,
  node.group=list(Gender=1:6, Family=7:10, Country=11:12),
  node.color=c("antiquewhite", "lightsalmon", "lightblue"),
  file="network.png")
plot(p)

unlink("network.png")  # delete file for code check

# network analysis with centrality plot (see `qgraph` package)
qgraph::centralityPlot(p, include="all", scale="raw",
                       orderBy="Strength")

# graphical lasso-estimation of partial correlation matrix
plot_network(
  d, words,
  index="glasso",
  # threshold=TRUE,
  node.group=list(Gender=1:6, Family=7:10, Country=11:12),
  node.color=c("antiquewhite", "lightsalmon", "lightblue"))
}
}
\seealso{
\code{\link[=plot_similarity]{plot_similarity()}}

\code{\link[=plot_wordvec_tSNE]{plot_wordvec_tSNE()}}
}
