% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Q2q.R
\name{getqxt}
\alias{getqxt}
\title{getqxt}
\usage{
getqxt(Qxt, nag, t)
}
\arguments{
\item{Qxt}{A numerical matrix of Five-ages mortality rates without an age identification column and a time identification row.}

\item{nag}{The number of age groups.}

\item{t}{The number of years.}
}
\value{
qxt : a matrix containing the age-specific mortality rates by age x in rows and year t in columns.

lxt : a matrix containing the evolution of the population of survivors over age x for each year t.

dxt : a matrix containing the theoretical distribution of deaths by age x for each year t.

qxtl : the age-specific mortality rates interpolated using the Lagrange method for each year t.

qxtk : the age specific mortality rates interpolated using the Karup-King method for each year t.

junct_ages : a vector containing the ages where qxtk and qxtl have been joined, for each year t.
}
\description{
It enables for interpolating age-specific mortality rates for a multi-annual life tables.
}
\examples{
getqxt(Qxt=LT, nag=17, t=38)
}
\author{
Farid FLICI
}
