% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QQnorm.r
\name{QQnorm}
\alias{QQnorm}
\title{QQ Plot with Correlation}
\usage{
QQnorm(X, main="", ylab="", censor=0, winsor=0,
       joinem=FALSE, ylim=c(NA,NA), isBC=FALSE, is2pBC=FALSE,
       doplot=TRUE, showP=TRUE, fitline=TRUE, showsum=FALSE)
}
\arguments{
\item{X}{the numeric data vector to be plotted.  Censored values should
be reported as the censoring value.}

\item{main}{the header text.}

\item{ylab}{the name of the variable.}

\item{censor}{\emph{optional} (default of 0) - the number of data censored on the left.}

\item{winsor}{\emph{optional} (default of 0) - the number of data winsored in each tail.}

\item{joinem}{\emph{optional} (default of FALSE) - if TRUE the plot is drawn as a
segmented line, if FALSE the individual points are plotted as x if winsorized, else *.}

\item{ylim}{\emph{optional} - y limits on the plot.}

\item{isBC}{\emph{optional} (default of FALSE) - if true, the data set is a Box-Cox
transform of the original data.}

\item{is2pBC}{\emph{optional} (default of FALSE) - if true, the data set is a
shifted Box-Cox tranform.}

\item{doplot}{\emph{optional} (default of TRUE) - if true, the QQ plot is drawn.}

\item{showP}{\emph{optional} (default of TRUE) - if true, the QQCC P value is shown on the plot.}

\item{fitline}{\emph{optional} (default of TRUE) - if true, the QQ regression line is plotted.}

\item{showsum}{\emph{optional} (default of FALSE) - if true, the intercept and
slope of the QQ regression are shown.}
}
\value{
A list containing the following components:

\item{correl}{the QQ correlation coefficient.}
\item{Pval}{the P value of the QQ correlation coefficient.}
\item{mean}{the mean of the data.}
\item{sd}{the sd of the data.}
\item{intercept}{the intercept of the QQ regression line, used in place of
the mean when there is censoring or winsorization.}
\item{slope}{the slope of the QQ regression line, used in place of
the sd when there is censorin or winsorization.}
}
\description{
Creates QQ plot of complete or censored data, with summaries and test.
}
\details{
Makes QQ plot of complete or censored data, as input by user:
\itemize{
\item fits regression line to complete uncensored portion of data,
\item calculates the QQ correlation coefficient of the fitted line, and
\item reports the P value of the QQ correlation coefficient as calculated by \code{BCR_pval}.
Parameters \code{isBC} and \code{is2pBC} are relevant to the P value calculation.
}
}
\examples{
# parameters
mu    <- 40
sigma <- 10
n     <- 120
# identifying winsoring
wins  <- trunc(n/40)
# replicable randomization
set.seed(1069)
X     <- mu + sigma*rnorm(n)
# replicable randomization with heavy tails
set.seed(1069)
HT    <- mu + sigma * rt(n, 5)

# retain original visual settings
oldsettings <- par(mfrow=par()$mfrow, oma=par()$oma)
# visual settings
par(mfrow=c(2,2))
par(oma=c(0,0,2,0))
# plot to compare
base <- QQnorm(X, main="Base normal", showsum=TRUE)
title("Illustrating QQnorm with para_limits", outer=TRUE)
basew <- QQnorm(X, main="Winsorized", winsor=wins, showsum=TRUE)
ht   <- QQnorm(HT, main="Heavy tail", showsum=TRUE)
htw  <- QQnorm(HT, main="Winsorized", winsor=wins, showsum=TRUE)
# restore
par(oldsettings)

}
\references{
Hawkins DM, Esquivel RN (2024). A Quantile-Quantile Toolbox for
Reference Intervals.  \emph{The Journal of Applied Laboratory Medicine}, \strong{9:2}, 357-370.
}
\author{
Douglas M. Hawkins, Jessica J. Kraker \href{mailto:krakerjj@uwec.edu}{krakerjj@uwec.edu}
}
