% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rq.break.R
\name{rq.break}
\alias{rq.break}
\title{Testing for Breaks and Estimating Break Dates and Sizes with Confidence Intervals}
\usage{
rq.break(y, x, vec.tau, N, trim.e, vec.time, m.max, v.a, v.b, verbose)
}
\arguments{
\item{y}{a numeric vector, the outcome variable (NT x 1), the first N units are from the first period,
the next N from the second period, and so forth.}

\item{x}{A matrix of regressors (NT x p), structured in the same way as y, a column of ones will be automatically added to x.}

\item{vec.tau}{a numeric vector, quantiles used for break estimation, for example \code{vec.tau = seq(0.20, 0.80, by = 0.10)}}

\item{N}{a numeric vector, the number of cross-sectional units. Set to 1 for a time series quantile regression.}

\item{trim.e}{a scalar between 0 and 1, the trimming proportion.
For example, if \code{trim.e=0.1}, the minimum regime length is 0.1 times the data span.}

\item{vec.time}{a vector of dates, needed for reporting the estimated break dates, in the format of (starting date...ending date);
If set to NULL, the break dates will be reported as indices (e.g., 55 for the 55th observation in the sample).}

\item{m.max}{the maximum number of breaks allowed.}

\item{v.a}{the significance level used for determining the number of breaks; 1, 2 or 3 for 10\%, 5\% or 1\%, respectively}

\item{v.b}{the coverage level for constructing the confidence intervals of break dates; 1 or 2 for 90\% and 95\%, respectively.}

\item{verbose}{Logical; set to TRUE to print estimates to the console. Default is FALSE.}
}
\value{
A list containing:
\itemize{
\item \verb{$s.out}: A list with break testing results, estimated break dates, confidence intervals, and coefficient estimates
based on individual quantiles.
\item \verb{$m.out}: A list with break testing results, estimated break dates, confidence intervals, and coefficient estimates
obtained by testing and estimating breaks using multiple quantiles simultaneously.
}

Each list (\code{s.out} or \code{m.out}) contains:
\itemize{
\item \code{test_tau}: A matrix of test statistics and critical values for break detection at quantile \code{tau}.
\item \code{nbreak_tau}: The number of detected breaks at quantile \code{tau}.
\item \code{br_est_tau}: A matrix of estimated break dates and their confidence intervals at quantile \code{tau}.
\item \code{br_est_time_tau}: The same as \code{br_est_tau}, but with break dates reported in calendar format (if \code{vec.time} is provided and is not NULL).
\item \code{coef_tau}: Estimated regression coefficients for each regime at quantile \code{tau}.
\item \code{bsize_tau}: Break size estimates for each transition between regimes at quantile \code{tau}.
}
}
\description{
This is the main function of this package for testing breaks in quantile regression models
and estimating break dates and break sizes with corresponding confidence intervals.
}
\examples{
\donttest{
## Example 1
## Time series example, using GDP data
## data
data(gdp)
y        = gdp$gdp
x        = gdp[,c("lag1", "lag2")]
vec.time = gdp$yq

## the maximum number of breaks allowed
m.max = 3

## the signifance level for sequenatial testing
## 1, 2 or 3 for 10\%, 5\% or 1\%, respectively
v.a = 2

## the significance level for the confidence intervals of estimated break dates.
## 1 or 2 for 90\% and 95\%, respectively.
v.b = 2

## the size of the cross-section
N = 1

## the trimming proportion for estimating the break dates
## (represents the minimum length of a regime; used to exclude
## the boundaries of the sample)
trim.e = 0.15

## quantiles
vec.tau = seq(0.20, 0.80, by = 0.150)

verbose = FALSE #do not print

## main estimation
res = rq.break(y, x, vec.tau, N, trim.e, vec.time, m.max, v.a, v.b, verbose)

}

}
\references{
Koenker, R. and G. Bassett Jr. (1978).
Regression quantiles. \emph{Econometrica}, 46(1), 33-50.

Oka, T. and Z. Qu (2011). Estimating Structural Changes in Regression Quantiles.
\emph{Journal of Econometrics}, 162(2), 248-267.

Qu, Z. (2008). Testing for Structural Change in Regression Quantiles.
\emph{Journal of Econometrics}, 146(1), 170-184.
}
