% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/velocity_track.R
\name{velocity_track}
\alias{velocity_track}
\title{Calculate velocities and relative stride lengths for tracks}
\usage{
velocity_track(data, H, G = NULL, method = NULL)
}
\arguments{
\item{data}{A \code{track} R object, which is a list consisting of two elements:
\itemize{
\item \strong{\code{Trajectories}}: A list of interpolated trajectories, where each trajectory is a series of midpoints between consecutive footprints.
\item \strong{\code{Footprints}}: A list of data frames containing footprint coordinates, metadata (e.g., image reference, ID), and a marker indicating whether the footprint is actual or inferred.
}}

\item{H}{A numeric vector representing the height at the hip (in meters) for each track maker. The length of this vector should match the number of tracks in the data.}

\item{G}{Gravity acceleration (in meters per second squared). Default is \code{9.8}.}

\item{method}{A character vector specifying the method to calculate velocities for each track. Method \code{"A"} follows the approach from Alexander (1976), while method \code{"B"} is based on Ruiz & Torices (2013). If \code{NULL}, method \code{"A"} will be used for all tracks.}
}
\value{
A \code{track velocity} R object consisting of a list of lists, where each sublist contains the computed parameters for a corresponding track.
The parameters included are:
\itemize{
\item \code{Step_velocities}: A vector of velocities for each step in the track (in meters per second).
\item \code{Mean_velocity}: The mean velocity across all steps in the track (in meters per second).
\item \code{Standard_deviation_velocity}: The standard deviation of velocities across all steps in the track (in meters per second).
\item \code{Maximum_velocity}: The maximum velocity among all steps in the track (in meters per second).
\item \code{Minimum_velocity}: The minimum velocity among all steps in the track (in meters per second).
\item \code{Step_relative_stride}: A vector of relative stride lengths for each step in the track (dimensionless).
\item \code{Mean_relative_stride}: The mean relative stride length across all steps in the track (dimensionless).
\item \code{Standard_deviation_relative_stride}: The standard deviation of relative stride lengths across all steps in the track (dimensionless).
\item \code{Maximum_relative_stride}: The maximum relative stride length among all steps in the track (dimensionless).
\item \code{Minimum_relative_stride}: The minimum relative stride length among all steps in the track (dimensionless).
}
}
\description{
\code{velocity_track()} calculates the velocities and relative stride lengths for each step in a series of tracks, based on the step length, height at the hip, and gravity acceleration.
}
\details{
The \code{velocity_track()} function calculates velocities using two methods:

\strong{Method A}: Based on Alexander (1976), with the formula:
\deqn{v = 0.25 \cdot \sqrt{G} \cdot S^{1.67} \cdot H^{-1.17}}{v = 0.25 * sqrt(G) * S^1.67 * H^-1.17}
\itemize{
\item \strong{v}: Velocity of the track-maker (in meters per second).
\item \strong{G}: Acceleration due to gravity (in meters per second squared), typically \eqn{9.81\ \text{m/s}^2}.
\item \strong{S}: Stride length, which is the distance between consecutive footprints (in meters).
\item \strong{H}: Height at the hip of the track-maker (in meters).
\item The coefficients \eqn{0.25}, \eqn{1.67}, and \eqn{-1.17} are derived from empirical studies. These coefficients adjust the formula to account for different animal sizes and gaits.
}

This method applies to a wide range of terrestrial vertebrates and is used to estimate velocity across different gaits.

\strong{Method B}: Based on Ruiz & Torices (2013), with the formula:
\deqn{v = 0.226 \cdot \sqrt{G} \cdot S^{1.67} \cdot H^{-1.17}}{v = 0.226 * sqrt(G) * S^1.67 * H^-1.17}
\itemize{
\item \strong{v}: Velocity of the track-maker (in meters per second).
\item \strong{G}: Acceleration due to gravity (in meters per second squared), typically \eqn{9.81\ \text{m/s}^2}.
\item \strong{S}: Stride length (in meters).
\item \strong{H}: Height at the hip of the track-maker (in meters).
\item The oefficient \eqn{0.226} in method B is a refinement based on updated data for bipedal locomotion.
}

Based on Thulborn & Wade (1984), it is possible to identify the gaits of track-makers on the basis of relative stride length, as follows:
\itemize{
\item \strong{Walk}: \eqn{A/H < 2.0}; locomotor performance equivalent to walking in mammals.
\item \strong{Trot}: \eqn{2.0 \leq A/H \leq 2.9}; locomotor performance equivalent to trotting or racking in mammals.
\item \strong{Run}: \eqn{A/H > 2.9}; locomotor performance equivalent to cantering, galloping, or sprinting in mammals.
}
}
\section{Logo}{

\if{html}{\figure{Logo.png}{options: width=30\%}}
}

\examples{
# Example 1: Calculate velocities for the MountTom dataset using default settings.
# H_mounttom contains hip heights for each track in the MountTom dataset.
# The function will use the default method "A" for all tracks.
# Hip heights are inferred as four times the footprint length, following Alexander's approach.
H_mounttom <- c(
  1.380, 1.404, 1.320, 1.736, 1.364, 1.432, 1.508, 1.768, 1.600,
  1.848, 1.532, 1.532, 0.760, 1.532, 1.688, 1.620, 0.636, 1.784, 1.676, 1.872,
  1.648, 1.760, 1.612
)
velocity_track(MountTom, H = H_mounttom)

# Example 2: Calculate velocities for the PaluxyRiver dataset using default settings.
# H_paluxyriver contains hip heights for each track in the PaluxyRiver dataset.
# The function will use the default method "A" for all tracks.
# Hip heights are inferred as four times the footprint length, following Alexander's approach.
H_paluxyriver <- c(3.472, 2.200)
velocity_track(PaluxyRiver, H = H_paluxyriver)

# Example 3: Calculate velocities for the PaluxyRiver dataset using different methods
# for velocity calculation. Method "A" is used for sauropods, which is more
# appropriate for quadrupedal dinosaurs. Method "B" is used for theropods, which
# is more appropriate for bipedal dinosaurs. Hip heights are inferred as four times
# the footprint length, following Alexander's approach.
H_paluxyriver <- c(3.472, 2.200)
Method_paluxyriver <- c("A", "B")
velocity_track(PaluxyRiver, H = H_paluxyriver, method = Method_paluxyriver)

}
\references{
Alexander, R. M. (1976). Estimates of speeds of dinosaurs. Nature, 261(5556), 129-130.

Ruiz, J., & Torices, A. (2013). Humans running at stadiums and beaches and the accuracy of speed estimations from fossil trackways. Ichnos, 20(1), 31-35.

Thulborn, R. A., & Wade, M. (1984). Dinosaur trackways in the Winton Formation (mid-Cretaceous) of Queensland. Memoirs of the Queensland Museum, 21(2), 413-517.
}
\seealso{
\code{\link{tps_to_track}}
}
\author{
Humberto G. Ferrón

humberto.ferron@uv.es

Macroevolution and Functional Morphology Research Group (www.macrofun.es)

Cavanilles Institute of Biodiversity and Evolutionary Biology

Calle Catedrático José Beltrán Martínez, nº 2

46980 Paterna - Valencia - Spain

Phone: +34 (9635) 44477
}
