% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/critical_value.R
\name{compute_CV}
\alias{compute_CV}
\title{Compute the critical value for two-sample KBQD tests}
\usage{
compute_CV(
  B,
  Quantile,
  data_pool,
  size_x,
  size_y,
  h,
  method,
  b = 1,
  compute_variance
)
}
\arguments{
\item{B}{the number of bootstrap/permutation/subsampling samples to generate.}

\item{Quantile}{the quantile of the bootstrap/permutation/subsampling
distribution to use as the critical value.}

\item{data_pool}{a matrix containing the data to be used in the test.}

\item{size_x}{the number of rows in the \code{data_pool} matrix
corresponding to group X.}

\item{size_y}{the number of rows in the \code{data_pool} matrix
corresponding to group Y.}

\item{h}{the tuning parameter for the kernel test.}

\item{method}{the method to use for computing the critical value
(one of "bootstrap", "permutation", or "subsampling").}

\item{b}{the subsampling block size (only used if \code{method} is
"subsampling").}

\item{compute_variance}{indicates if the nonparametric variance is computed.
Default is TRUE.}
}
\value{
the critical value for the specified method and significance level.
}
\description{
This function computes the critical value for two-sample kernel tests with
centered Gaussian kernel
using one of three methods: bootstrap, permutation, or subsampling.
}
\references{
Markatou Marianthi & Saraceno Giovanni (2024). “A Unified Framework for
Multivariate Two- and k-Sample Kernel-based Quadratic Distance
Goodness-of-Fit Tests.”
https://doi.org/10.48550/arXiv.2407.16374
}
\keyword{internal}
