% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peer.ces.R
\name{summary.cespeer}
\alias{summary.cespeer}
\alias{print.summary.cespeer}
\alias{print.cespeer}
\title{Summary for the Estimation of CES-based Peer Effects Models}
\usage{
\method{summary}{cespeer}(object, fullparameters = TRUE, ...)

\method{print}{summary.cespeer}(x, ...)

\method{print}{cespeer}(x, ...)
}
\arguments{
\item{object}{An object of class \code{\link{cespeer}}.}

\item{fullparameters}{A logical value indicating whether all parameters should be summarized (may be useful for the structural model).}

\item{...}{Further arguments passed to or from other methods.}

\item{x}{An object of class \code{\link{summary.cespeer}} or \code{\link{cespeer}}.}
}
\value{
A list containing:
\item{model.info}{A list with information about the model, such as the number of subnets, number of observations, and other key details.}
\item{coefficients}{A summary of the estimates, standard errors, and p-values.}
\item{gmm}{A list of GMM estimation results, including parameter estimates, the covariance matrix, and related statistics.}
}
\description{
Summary and print methods for the class \code{\link{cespeer}}.
}
