% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-transform.R
\name{transform_checkboxes}
\alias{transform_checkboxes}
\title{Transformation of Checkboxes with Branching Logic}
\usage{
transform_checkboxes(data, dic, event_form = NULL, checkbox_na = FALSE)
}
\arguments{
\item{data}{Data frame containing data from REDCap.}

\item{dic}{Data frame  containing the dictionary read from REDCap.}

\item{event_form}{Data frame  containing the correspondence of each event with each form.}

\item{checkbox_na}{Logical indicating if values of checkboxes with branching logic should be set to missing only when the branching logic is missing (\code{FALSE}), or also when the branching logic is not satisfied (\code{TRUE}). The default is \code{FALSE}.}
}
\description{
This function inspects all the checkboxes in the study to determine if they have a branching logic. If a branching logic is present and its result is missing, the function will input a missing value into the checkbox. If \code{checkbox_na} is \code{TRUE}, the function will additionally input a missing value when the branching logic isn't satisfied, not just when it is missing. If a branching logic cannot be found or the logic cannot be transcribed due to the presence of smart variables, the variable is added to a list of reviewable variables that will be printed.

The function returns the dataset with the transformed checkboxes and a table summarizing the results.
}
