% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_checkbox.R
\name{rd_checkbox}
\alias{rd_checkbox}
\title{Transform Checkbox Variables in a REDCap Project}
\usage{
rd_checkbox(
  project = NULL,
  data = NULL,
  dic = NULL,
  event_form = NULL,
  checkbox_labels = c("No", "Yes"),
  checkbox_names = TRUE,
  na_logic = "missing"
)
}
\arguments{
\item{project}{A list containing the REDCap data, dictionary, and event mapping (expected \code{redcap_data()} output). Overrides \code{data}, \code{dic}, and \code{event_form}.}

\item{data}{A \code{data.frame} or \code{tibble} with the REDCap dataset.}

\item{dic}{A \code{data.frame} with the REDCap dictionary.}

\item{event_form}{Only applicable for longitudinal projects (presence of events). Event-to-form mapping for longitudinal projects.}

\item{checkbox_labels}{Character vector of length 2 for labels of unchecked/checked values. Default: \code{c("No", "Yes")}.}

\item{checkbox_names}{Logical. If \code{TRUE} (default), checkbox columns are renamed using choice labels.}

\item{na_logic}{Controls how missing values are set based on branching logic. Must be one of \code{"none"} (do nothing), \code{"missing"} (set to \code{NA} only when the logic evaluation is \code{NA}), or \code{"eval"} (set to \code{NA} when the logic evaluates to \code{FALSE}). Defaults to \code{"missing"}.}
}
\value{
A list with:
\describe{
\item{data}{Transformed dataset with checkbox fields as factors and optionally renamed.}
\item{dictionary}{Updated dictionary with checkbox fields expanded and optionally renamed.}
\item{event_form}{The \code{event_form} passed in (if applicable).}
\item{results}{Summary of transformations and any fields needing review.}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function is used to process checkbox variables in a REDCap dataset. By default, it changes their default categories ("Unchecked" and "Checked") to new ones ("No" and "Yes). Optionally, the function can also evaluate the branching logic for checkbox fields and adjust the data and dictionary accordingly.
}
\details{
\itemize{
\item Checkbox columns are expected in REDCap wide format (\code{field___code}).
\item Branching logic evaluation requires \code{event_form} for longitudinal projects.
\item Names are cleaned and truncated to 60 characters; uniqueness is enforced.
\item Fields that cannot be evaluated are listed in \code{results}.
}
}
\examples{
# Basic usage with a project object
res <- rd_checkbox(covican)

# With custom labels
res <- rd_checkbox(data = covican$data,
                   dic = covican$dictionary,
                   checkbox_labels = c("Not present", "Present"))

# Keep original checkbox names
res <- rd_checkbox(covican, checkbox_names = FALSE)

# Longitudinal project with NA logic
res <- rd_checkbox(data = covican$data,
                   dic = covican$dictionary,
                   event_form = covican$event_form,,
                   na_logic = "eval")

}
