% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_helpers.R
\name{calculate_hedonic_imputation}
\alias{calculate_hedonic_imputation}
\title{Calculate imputation averages with the 1st period as base period}
\usage{
calculate_hedonic_imputation(
  dataset_temp,
  period_temp,
  dependent_variable_temp,
  independent_variables_temp,
  number_of_observations_temp,
  period_list_temp
)
}
\arguments{
\item{dataset_temp}{table with data}

\item{period_temp}{'period'}

\item{dependent_variable_temp}{usually the sale price}

\item{independent_variables_temp}{vector with quality determining variables}

\item{period_list_temp}{list with all available periods}
}
\value{
Table with imputation averages per period
}
\description{
Prices are estimated based on a provided Hedonic model
The model values are calculated for each period in the data
With these values, new prices of base period observations are estimated.
With this function, imputations according to the Laspeyres and Paasche method can be estimated.
}
\author{
Farley Ishaak
}
\keyword{internal}
