% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_marginal_distributions.R
\name{get_marginal_distributions}
\alias{get_marginal_distributions}
\title{Generate Marginal Distributions for a given data frame}
\usage{
get_marginal_distributions(df, variables = c(), print = FALSE)
}
\arguments{
\item{df}{Data frame to get the marginal distributions from}

\item{variables}{(Optional) variable (columns) to select, Default: c()}

\item{print}{Whether to print the marginal distributions
to the console, Default: FALSE}
}
\value{
A list of marginal distributions of an S3 RESIDE Class
}
\description{
Generate Marginal Distributions from a given
data frame with options to specify which variables to use.
}
\details{
A function to generate marginal distributions from
a given data frame, depending on the variable type the marginals
will differ, for binary variables a mean and number of missing is generated
for continuous variables, they are first transformed and both mean and sd of
the transformed variables are stored along with the quantile mapping for back
transformation. For categorical variables, the number of each category is
stored, missing values are categorise as "missing".
}
\examples{
marginal_distributions <- get_marginal_distributions(
  IST,
  variables <- c(
    "SEX",
    "AGE",
    "ID14",
    "RSBP",
    "RATRIAL"
  )
)
}
\seealso{
\code{\link{export_marginal_distributions}}
}
