% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_maxk.R
\name{compute_maxk}
\alias{compute_maxk}
\title{Compute the maximum k for a given sample}
\usage{
compute_maxk(samp = NULL, probs = NULL, quants = NULL, k_range = c(1, 120))
}
\arguments{
\item{samp}{Sample of data to model}

\item{probs}{Probabilities of interest to generate the max_k line}

\item{quants}{Estimated quantiles of interest to generate the max_k line}

\item{k_range}{Range of k values for the optimization function}
}
\value{
Returns estimated maxk for the sample and quantiles given.
}
\description{
\code{compute_maxk} returns the estimated quantiles for the chosen probabilities from the input sample.
This method uses the sample quantile method number 8 from the default quantile function.
}
\examples{
samp <- rnorm(1e3, mean = 100, sd = 10)
probs <- c(1-1e-1, 1-0.5e-1, 1-1e-2)
quants <- c(100, 125, 150)
estimated_max_k <- compute_maxk(samp = samp, probs = probs, quants = quants, k_range = c(1,100))
}
\keyword{RESTK}
