/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.algorithm.implementation;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.DefaultPreprocessingFilter;
import ec.satoolkit.DefaultSeriesDecomposition;
import ec.satoolkit.GenericSaDiagnostics;
import ec.satoolkit.GenericSaProcessingFactory;
import ec.satoolkit.GenericSaResults;
import ec.satoolkit.benchmarking.SaBenchmarkingResults;
import ec.satoolkit.x11.Mstatistics;
import ec.satoolkit.x11.X11Results;
import ec.satoolkit.x13.X11Decomposer;
import ec.satoolkit.x13.X13Specification;
import ec.tstoolkit.algorithm.AlgorithmDescriptor;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.IProcessingFactory;
import ec.tstoolkit.algorithm.IProcessingNode;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.algorithm.SequentialProcessing;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.x13.BasicSpec;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class X13ProcessingFactory
extends GenericSaProcessingFactory
implements IProcessingFactory<X13Specification, TsData, CompositeResults> {
    public static final String METHOD = "x13";
    public static final String VERSION = "0.1.0.0";
    public static final AlgorithmDescriptor DESCRIPTOR = new AlgorithmDescriptor("Seasonal adjustment", "x13", "0.1.0.0");
    public static final String MSTATISTICS = "m-statistics";
    public static final X13ProcessingFactory instance = new X13ProcessingFactory();

    protected X13ProcessingFactory() {
    }

    private static SequentialProcessing<TsData> create(X13Specification xspec, ProcessingContext context) {
        DecompositionMode mode;
        SequentialProcessing<TsData> processing = new SequentialProcessing<TsData>();
        BasicSpec basic = xspec.getRegArimaSpecification().getBasic();
        X13ProcessingFactory.addInitialStep(basic.getSpan(), basic.isPreliminaryCheck(), processing);
        if (xspec.getRegArimaSpecification().getBasic().isPreprocessing()) {
            X13ProcessingFactory.addPreprocessingStep(xspec.getRegArimaSpecification().build(context), xspec.getX11Specification().getForecastHorizon(), processing);
        }
        boolean noapply = (mode = xspec.getX11Specification().getMode()) == DecompositionMode.PseudoAdditive;
        DefaultPreprocessingFilter filter = new DefaultPreprocessingFilter(noapply);
        filter.setForecastHorizon(xspec.getX11Specification().getForecastHorizon());
        filter.setBackcastHorizon(xspec.getX11Specification().getBackcastHorizon());
        X13ProcessingFactory.addDecompositionStep(new X11Decomposer(xspec.getX11Specification()), filter, processing);
        X13ProcessingFactory.addFinalStep(filter, processing);
        X13ProcessingFactory.addMStep(processing);
        X13ProcessingFactory.addBenchmarkingStep(xspec.getBenchmarkingSpecification(), processing);
        X13ProcessingFactory.addGeneralStep(processing);
        X13ProcessingFactory.addDiagnosticsStep(processing);
        return processing;
    }

    private static void addMStep(SequentialProcessing processing) {
        processing.add(new IProcessingNode<TsData>(){

            @Override
            public String getName() {
                return X13ProcessingFactory.MSTATISTICS;
            }

            @Override
            public String getPrefix() {
                return X13ProcessingFactory.MSTATISTICS;
            }

            @Override
            public IProcessing.Status process(TsData input, Map<String, IProcResults> results) {
                IProcResults decomp = results.get("decomposition");
                if (decomp == null || !(decomp instanceof X11Results)) {
                    return IProcessing.Status.Unprocessed;
                }
                X11Results x11 = (X11Results)decomp;
                Mstatistics mstats = Mstatistics.computeFromX11(x11.getSeriesDecomposition().getMode(), x11.getInformation());
                results.put(X13ProcessingFactory.MSTATISTICS, mstats);
                return IProcessing.Status.Valid;
            }
        });
    }

    public SequentialProcessing<TsData> generateProcessing(X13Specification xspec, ProcessingContext context) {
        return X13ProcessingFactory.create(xspec, context);
    }

    public SequentialProcessing<TsData> generateProcessing(X13Specification xspec) {
        return X13ProcessingFactory.create(xspec, null);
    }

    public static CompositeResults process(TsData s, X13Specification xspec, ProcessingContext context) {
        SequentialProcessing<TsData> processing = X13ProcessingFactory.create(xspec, context);
        return processing.process((Object)s);
    }

    public static CompositeResults process(TsData s, X13Specification xspec) {
        return X13ProcessingFactory.process(s, xspec, null);
    }

    @Override
    public void dispose() {
    }

    @Override
    public AlgorithmDescriptor getInformation() {
        return DESCRIPTOR;
    }

    @Override
    public boolean canHandle(IProcSpecification spec) {
        return spec instanceof X13Specification;
    }

    @Override
    public Map<String, Class> getSpecificationDictionary(Class<X13Specification> specClass) {
        HashMap<String, Class> dic = new HashMap<String, Class>();
        X13Specification.fillDictionary(null, dic);
        return dic;
    }

    @Override
    public Map<String, Class> getOutputDictionary(boolean compact) {
        LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
        PreprocessingModel.fillDictionary(null, dic, compact);
        X11Results.fillDictionary("decomposition", dic, compact);
        Mstatistics.fillDictionary(MSTATISTICS, dic, compact);
        DefaultSeriesDecomposition.fillDictionary(null, dic, compact);
        SaBenchmarkingResults.fillDictionary("benchmarking", dic, compact);
        GenericSaResults.fillDictionary(null, dic, compact);
        GenericSaDiagnostics.fillDictionary("diagnostics", dic, compact);
        return dic;
    }
}

