/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.information;

import ec.tstoolkit.information.Information;
import ec.tstoolkit.information.InformationComparer;
import ec.tstoolkit.utilities.WildCards;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public final class InformationSet
implements Cloneable {
    public static final char SEP = '.';
    public static final String STRSEP = new String(new char[]{'.'});
    public static final String CONTENT = "content";
    public static final String TYPE_KEY = "type";
    public static final String VERSION_KEY = "version";
    public static final String LOG = "log";
    private ConcurrentHashMap<String, IndexedObject<?>> information_ = new ConcurrentHashMap();
    private boolean locked_;
    public static final String ERRORS = "errors";
    public static final String WARNINGS = "warnings";

    public static String concatenate(String ... s) {
        switch (s.length) {
            case 0: {
                return "";
            }
            case 1: {
                return s[0];
            }
        }
        boolean first = true;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length; ++i) {
            if (s[i] == null) continue;
            if (!first) {
                builder.append('.');
            } else {
                first = false;
            }
            builder.append(s[i]);
        }
        return builder.toString();
    }

    public static boolean isPrefix(String fullName, String prefix) {
        if (fullName.length() <= prefix.length() + 1) {
            return false;
        }
        if (fullName.charAt(prefix.length()) != '.') {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (fullName.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasWildCards(String str) {
        return str.indexOf(42) >= 0 || str.indexOf(63) >= 0;
    }

    public static String removePrefix(String name) {
        int pos;
        int len = name.length();
        for (pos = 0; pos < len && name.charAt(pos) != '.'; ++pos) {
        }
        if (pos == len) {
            return null;
        }
        return name.substring(pos + 1, len);
    }

    public static String simpleName(String fullName) {
        int pos;
        for (pos = fullName.length(); pos > 0 && fullName.charAt(pos - 1) != '.'; --pos) {
        }
        if (pos > 0) {
            return fullName.substring(pos, fullName.length());
        }
        return fullName;
    }

    public static String[] split(String fullName) {
        int nsep = 0;
        int len = fullName.length();
        for (int i = 0; i < len; ++i) {
            if (fullName.charAt(i) != '.') continue;
            ++nsep;
        }
        if (nsep == 0) {
            return new String[]{fullName};
        }
        String[] s = new String[nsep + 1];
        int pos = 0;
        int end = 0;
        int beg = 0;
        while (pos < nsep) {
            if (fullName.charAt(end) == '.') {
                s[pos++] = fullName.substring(beg, end);
                end = beg = end + 1;
            }
            ++end;
        }
        s[pos] = fullName.substring(beg);
        return s;
    }

    public static boolean wildCompare(String wString, String curString) {
        if (wString == null) {
            return true;
        }
        WildCards wc = new WildCards(wString);
        return wc.match(curString);
    }

    public static String item(String prefix, String name) {
        if (prefix == null || prefix.isEmpty()) {
            return name;
        }
        if (name == null || name.isEmpty()) {
            return prefix;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(prefix).append('.').append(name);
        return builder.toString();
    }

    public InformationSet clone() {
        try {
            InformationSet set = (InformationSet)super.clone();
            set.information_ = new ConcurrentHashMap();
            for (Map.Entry<String, IndexedObject<?>> kv : this.information_.entrySet()) {
                if (kv.getValue().obj instanceof InformationSet) {
                    InformationSet subset = (InformationSet)kv.getValue().obj;
                    set.add(kv.getKey(), subset.clone());
                    continue;
                }
                set.add(kv.getKey(), kv.getValue().obj);
            }
            return set;
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    public boolean isLocked() {
        return this.locked_;
    }

    public void setLocked(boolean locked) {
        this.locked_ = locked;
        for (Map.Entry<String, IndexedObject<?>> kv : this.information_.entrySet()) {
            if (!(kv.getValue().obj instanceof InformationSet)) continue;
            ((InformationSet)kv.getValue().obj).setLocked(locked);
        }
    }

    public boolean set(Information<?> info) {
        if (this.locked_) {
            return false;
        }
        if (info == null || info.value == null) {
            return false;
        }
        this.information_.put(info.name, new IndexedObject(info.value));
        return true;
    }

    public boolean add(Information<?> info) {
        if (this.locked_) {
            return false;
        }
        if (info == null || info.value == null) {
            return false;
        }
        String name = info.name;
        while (this.information_.containsKey(name)) {
            name = name + "_";
        }
        this.information_.put(name, new IndexedObject(info.value));
        return true;
    }

    public <S> boolean add(String name, S info) {
        return this.add(new Information<S>(name, info));
    }

    public <S> boolean add(String[] deepname, S info) {
        int len = deepname.length - 1;
        if (len < 0) {
            return false;
        }
        if (len == 0) {
            return this.add(new Information<S>(deepname[0], info));
        }
        InformationSet cur = this;
        for (int i = 0; i < len; ++i) {
            if ((cur = cur.subSet(deepname[i])) != null) continue;
            return false;
        }
        return cur.add(new Information<S>(deepname[len], info));
    }

    public <S> boolean set(String[] deepname, S info) {
        int len = deepname.length - 1;
        if (len < 0) {
            return false;
        }
        if (len == 0) {
            return this.set(deepname[0], info);
        }
        InformationSet cur = this;
        for (int i = 0; i < len; ++i) {
            if ((cur = cur.subSet(deepname[i])) != null) continue;
            return false;
        }
        return cur.set(deepname[len], info);
    }

    public <S> boolean add(Enum e, S info) {
        return this.add(new Information<S>(e.toString(), info));
    }

    public void addWarning(String string) {
        if (this.locked_) {
            return;
        }
        this.addMessage(WARNINGS, string);
    }

    public void addError(String string) {
        if (this.locked_) {
            return;
        }
        this.addMessage(ERRORS, string);
    }

    private void addMessage(String item, String msg) {
        String[] items = this.get(item, String[].class);
        if (items != null) {
            String[] nitems = new String[items.length + 1];
            for (int i = 0; i < items.length; ++i) {
                nitems[i] = items[i];
            }
            nitems[items.length] = msg;
            this.set(item, nitems);
        } else {
            this.set(item, new String[]{msg});
        }
    }

    private void addMessages(String item, String[] msg) {
        String[] items = this.get(item, String[].class);
        if (items != null) {
            int i;
            String[] nitems = new String[items.length + msg.length];
            for (i = 0; i < items.length; ++i) {
                nitems[i] = items[i];
            }
            for (i = 0; i < msg.length; ++i) {
                nitems[items.length + i] = msg[i];
            }
            this.set(item, nitems);
        } else {
            this.set(item, msg);
        }
    }

    private List<String> allItems(String name) {
        ArrayList<String> allitems = new ArrayList<String>();
        String[] items = this.get(name, String[].class);
        if (items != null) {
            Collections.addAll(allitems, items);
        }
        List<Information<InformationSet>> subsets = this.select(InformationSet.class);
        for (Information<InformationSet> subset : subsets) {
            allitems.addAll(((InformationSet)subset.value).allItems(name));
        }
        return allitems;
    }

    public void clear() {
        if (this.locked_) {
            return;
        }
        this.information_.clear();
    }

    public void copy(InformationSet info) {
        for (Map.Entry<String, IndexedObject<?>> kv : info.information_.entrySet()) {
            if (kv.getValue().obj instanceof InformationSet) {
                InformationSet subset = (InformationSet)kv.getValue().obj;
                this.set(kv.getKey(), subset.clone());
                continue;
            }
            this.set(kv.getKey(), kv.getValue().obj);
        }
    }

    public String[] content() {
        Object[] inames = new IndexedName[this.information_.size()];
        int idx = 0;
        for (Map.Entry<String, IndexedObject<?>> kv : this.information_.entrySet()) {
            inames[idx++] = new IndexedName(kv.getValue().index, kv.getKey());
        }
        Arrays.sort(inames);
        String[] names = new String[inames.length];
        for (int i = 0; i < inames.length; ++i) {
            names[i] = ((IndexedName)inames[i]).name;
        }
        return names;
    }

    public <S> S deepSearch(String name, Class<S> sclass) {
        IndexedObject<?> iobj = this.information_.get(name);
        if (iobj != null) {
            return InformationSet.convert(iobj.obj, sclass);
        }
        List<Information<InformationSet>> subsets = this.select(InformationSet.class);
        if (subsets.isEmpty()) {
            return null;
        }
        for (Information<InformationSet> subset : subsets) {
            S rslt = ((InformationSet)subset.value).deepSearch(name, sclass);
            if (rslt == null) continue;
            return rslt;
        }
        return null;
    }

    private <S> void fillSelection(String path, InformationSet set, List<Information<S>> sel, Class<S> sclass) {
        for (Map.Entry<String, IndexedObject<?>> kv : set.information_.entrySet()) {
            S s = InformationSet.convert(kv.getValue().obj, sclass);
            if (s == null) continue;
            sel.add(new Information<S>(InformationSet.item(path, kv.getKey()), s, kv.getValue().index));
        }
        List<Information<InformationSet>> subsets = set.select(InformationSet.class);
        if (!subsets.isEmpty()) {
            for (Information<InformationSet> subset : subsets) {
                this.fillSelection(InformationSet.item(path, subset.name), (InformationSet)subset.value, sel, sclass);
            }
        }
    }

    private <S> void fillSelection(String path, InformationSet set, List<Information<S>> sel, WildCards wc, Class<S> sclass) {
        for (Map.Entry<String, IndexedObject<?>> kv : set.information_.entrySet()) {
            S s;
            if (!wc.match(kv.getKey()) || (s = InformationSet.convert(kv.getValue().obj, sclass)) == null) continue;
            sel.add(new Information<S>(InformationSet.item(path, kv.getKey()), s, kv.getValue().index));
        }
        List<Information<InformationSet>> subsets = set.select(InformationSet.class);
        if (!subsets.isEmpty()) {
            for (Information<InformationSet> subset : subsets) {
                this.fillSelection(InformationSet.item(path, subset.name), (InformationSet)subset.value, sel, wc, sclass);
            }
        }
    }

    public <S> List<Information<S>> deepSelect(String wc, Class<S> sclass) {
        ArrayList<Information<S>> list = new ArrayList<Information<S>>();
        WildCards w = new WildCards(wc);
        this.fillSelection(null, this, list, w, sclass);
        Collections.sort(list, new InformationComparer());
        return list;
    }

    public <S> List<Information<S>> deepSelect(Class<S> sclass) {
        ArrayList<Information<S>> list = new ArrayList<Information<S>>();
        this.fillSelection(null, this, list, sclass);
        Collections.sort(list, new InformationComparer());
        return list;
    }

    public List<String> errors() {
        return this.allItems(ERRORS);
    }

    public void fillDictionary(String prefix, List<String> items) {
        ArrayList<IndexedName> pnames = new ArrayList<IndexedName>();
        ArrayList<IndexedName> snames = new ArrayList<IndexedName>();
        for (Map.Entry<String, IndexedObject<?>> kv : this.information_.entrySet()) {
            if (kv.getValue().obj instanceof InformationSet) {
                snames.add(new IndexedName(kv.getValue().index, kv.getKey()));
                continue;
            }
            pnames.add(new IndexedName(kv.getValue().index, kv.getKey()));
        }
        Collections.sort(pnames);
        Collections.sort(snames);
        for (IndexedName pname : pnames) {
            items.add(prefix == null || prefix.isEmpty() ? pname.name : InformationSet.item(prefix, pname.name));
        }
        for (IndexedName sname : snames) {
            String nprefix;
            String string = nprefix = prefix == null || prefix.isEmpty() ? sname.name : InformationSet.item(prefix, sname.name);
            InformationSet subset = this.getSubSet(sname.name);
            if (subset == null) continue;
            subset.fillDictionary(nprefix, items);
        }
    }

    public void fillDictionary(String prefix, Map<String, Class> items) {
        ArrayList<IndexedName> pnames = new ArrayList<IndexedName>();
        ArrayList<IndexedName> snames = new ArrayList<IndexedName>();
        for (Map.Entry<String, IndexedObject<?>> kv : this.information_.entrySet()) {
            if (kv.getValue().obj instanceof InformationSet) {
                snames.add(new IndexedName(kv.getValue().index, kv.getKey()));
                continue;
            }
            pnames.add(new IndexedName(kv.getValue().index, kv.getKey()));
        }
        Collections.sort(snames);
        Collections.sort(pnames);
        for (IndexedName pname : pnames) {
            Object obj = this.information_.get((Object)pname.name).obj;
            if (obj == null) continue;
            items.put(prefix == null || prefix.isEmpty() ? pname.name : InformationSet.item(prefix, pname.name), obj.getClass());
        }
        for (IndexedName sname : snames) {
            String nprefix;
            String string = nprefix = prefix == null || prefix.isEmpty() ? sname.name : InformationSet.item(prefix, sname.name);
            InformationSet subset = this.getSubSet(sname.name);
            if (subset == null) continue;
            subset.fillDictionary(nprefix, items);
        }
    }

    public <T> void fillDictionary(String prefix, List<String> items, Class<T> tclass) {
        ArrayList<IndexedName> pnames = new ArrayList<IndexedName>();
        ArrayList<IndexedName> snames = new ArrayList<IndexedName>();
        for (Map.Entry<String, IndexedObject<?>> kv : this.information_.entrySet()) {
            if (kv.getValue().obj instanceof InformationSet) {
                snames.add(new IndexedName(kv.getValue().index, kv.getKey()));
                continue;
            }
            if (!tclass.isInstance(kv.getValue().obj)) continue;
            pnames.add(new IndexedName(kv.getValue().index, kv.getKey()));
        }
        Collections.sort(pnames);
        Collections.sort(snames);
        for (IndexedName pname : pnames) {
            items.add(prefix == null || prefix.isEmpty() ? pname.name : InformationSet.item(prefix, pname.name));
        }
        for (IndexedName sname : snames) {
            String nprefix;
            String string = nprefix = prefix == null || prefix.isEmpty() ? sname.name : InformationSet.item(prefix, sname.name);
            InformationSet subset = this.getSubSet(sname.name);
            if (subset == null) continue;
            subset.fillDictionary(nprefix, items, tclass);
        }
    }

    public Object get(String name) {
        IndexedObject<?> obj = this.information_.get(name);
        if (obj != null) {
            return obj.obj;
        }
        return null;
    }

    public Object get(Enum e) {
        return this.get(e.toString());
    }

    public <S> S get(String name, Class<S> sclass) {
        Object obj = this.get(name);
        return InformationSet.convert(obj, sclass);
    }

    public <S> S get(Enum e, Class<S> sclass) {
        return this.get(e.toString(), sclass);
    }

    public List<String> getDictionary() {
        ArrayList<String> items = new ArrayList<String>();
        String prefix = null;
        this.fillDictionary(prefix, items);
        return items;
    }

    public <T> List<String> getDictionary(Class<T> tclass) {
        ArrayList<String> items = new ArrayList<String>();
        String prefix = null;
        this.fillDictionary(prefix, items, tclass);
        return items;
    }

    public InformationSet getSubSet(String name) {
        return this.get(name, InformationSet.class);
    }

    public List<Information<?>> items() {
        ArrayList list = new ArrayList();
        for (Map.Entry<String, IndexedObject<?>> kv : this.information_.entrySet()) {
            list.add(new Information(kv.getKey(), kv.getValue().obj, kv.getValue().index));
        }
        Collections.sort(list, new InformationComparer());
        return list;
    }

    public void remove(String name) {
        if (this.locked_) {
            return;
        }
        this.information_.remove(name);
    }

    public void remove(Enum e) {
        this.remove(e.toString());
    }

    public <S> S search(String fullName, Class<S> sclass) {
        String[] split = InformationSet.split(fullName);
        if (split.length <= 1) {
            return this.search(new String[]{fullName}, sclass);
        }
        return this.search(split, sclass);
    }

    private InformationSet root(String[] names) {
        InformationSet cur = this;
        if (names.length > 1) {
            for (int i = 0; i < names.length - 1; ++i) {
                if ((cur = cur.getSubSet(names[i])) != null) continue;
                return null;
            }
        }
        return cur;
    }

    public <S> S search(String[] names, Class<S> sclass) {
        InformationSet cur = this.root(names);
        if (cur == null) {
            return null;
        }
        return cur.get(names[names.length - 1], sclass);
    }

    public <S> List<Information<S>> select(Class<S> sclass) {
        ArrayList<Information<S>> list = new ArrayList<Information<S>>();
        for (Map.Entry<String, IndexedObject<?>> kv : this.information_.entrySet()) {
            S s = InformationSet.convert(kv.getValue().obj, sclass);
            if (s == null) continue;
            list.add(new Information(kv.getKey(), kv.getValue().obj, kv.getValue().index));
        }
        Collections.sort(list, new InformationComparer());
        return list;
    }

    public List<Information<Object>> select(String wc) {
        String[] split = InformationSet.split(wc);
        InformationSet cur = this.root(split);
        if (cur == null) {
            return Collections.emptyList();
        }
        WildCards w = new WildCards(split[split.length - 1]);
        ArrayList<Information<Object>> list = new ArrayList<Information<Object>>();
        for (Map.Entry<String, IndexedObject<?>> kv : cur.information_.entrySet()) {
            if (!w.match(kv.getKey())) continue;
            list.add(new Information(kv.getKey(), kv.getValue().obj, kv.getValue().index));
        }
        Collections.sort(list, new InformationComparer());
        return list;
    }

    public <S> List<Information<S>> select(String wc, Class<S> sclass) {
        String[] split = InformationSet.split(wc);
        InformationSet cur = this.root(split);
        if (cur == null) {
            return Collections.emptyList();
        }
        WildCards w = new WildCards(split[split.length - 1]);
        ArrayList<Information<S>> list = new ArrayList<Information<S>>();
        for (Map.Entry<String, IndexedObject<?>> kv : cur.information_.entrySet()) {
            S s;
            if (!w.match(kv.getKey()) || (s = InformationSet.convert(kv.getValue().obj, sclass)) == null) continue;
            list.add(new Information(kv.getKey(), kv.getValue().obj, kv.getValue().index));
        }
        Collections.sort(list, new InformationComparer());
        return list;
    }

    public <S> boolean set(String name, S info) {
        if (this.locked_) {
            return false;
        }
        IndexedObject<?> obj = this.information_.get(name);
        if (obj != null && !obj.obj.getClass().isInstance(info)) {
            return false;
        }
        this.information_.put(name, new IndexedObject<S>(info));
        return true;
    }

    public <S> boolean set(Enum e, S info) {
        return this.set(e.toString(), info);
    }

    public InformationSet subSet(String name) {
        IndexedObject<?> obj = this.information_.get(name);
        if (obj == null) {
            if (!this.locked_) {
                InformationSet nset = new InformationSet();
                this.information_.put(name, new IndexedObject<InformationSet>(nset));
                return nset;
            }
            return null;
        }
        if (obj.obj instanceof InformationSet) {
            return (InformationSet)obj.obj;
        }
        return null;
    }

    public List<String> warnings() {
        return this.allItems(WARNINGS);
    }

    public void setContent(String type, String version) {
        InformationSet cnt = this.subSet(CONTENT);
        cnt.set(TYPE_KEY, type);
        if (version != null) {
            cnt.setContent(VERSION_KEY, version);
        }
    }

    public String getContentType() {
        InformationSet cnt = this.getSubSet(CONTENT);
        if (cnt == null) {
            return null;
        }
        return cnt.get(TYPE_KEY, String.class);
    }

    public String getContentVersion() {
        InformationSet cnt = this.getSubSet(CONTENT);
        if (cnt == null) {
            return null;
        }
        return cnt.get(VERSION_KEY, String.class);
    }

    public boolean isContent(String type, String version) {
        InformationSet cnt = this.getSubSet(CONTENT);
        if (cnt == null) {
            return false;
        }
        if (!type.equalsIgnoreCase(cnt.get(TYPE_KEY, String.class))) {
            return false;
        }
        return version == null || version.equalsIgnoreCase(cnt.get(VERSION_KEY, String.class));
    }

    public InformationSet filter(List<String> dictionary) {
        InformationSet info = new InformationSet();
        for (String s : dictionary) {
            String[] path = InformationSet.split(s);
            Object item = this.search(path, Object.class);
            if (item == null) continue;
            info.add(path, item);
        }
        return info;
    }

    public boolean merge(InformationSet info) {
        block8: for (Map.Entry<String, IndexedObject<?>> kv : info.information_.entrySet()) {
            if (!this.information_.containsKey(kv.getKey())) {
                this.information_.put(kv.getKey(), new IndexedObject(kv.getValue().obj));
                continue;
            }
            if (InformationSet.class.isInstance(kv.getValue().obj)) {
                InformationSet subset = this.getSubSet(kv.getKey());
                if (subset == null) {
                    return false;
                }
                subset.merge((InformationSet)kv.getValue().obj);
                continue;
            }
            switch (kv.getKey()) {
                case "warnings": {
                    this.addMessages(WARNINGS, (String[])kv.getValue().obj);
                    continue block8;
                }
                case "errors": {
                    this.addMessages(ERRORS, (String[])kv.getValue().obj);
                    continue block8;
                }
            }
            return false;
        }
        return true;
    }

    public boolean update(InformationSet info) {
        block8: for (Map.Entry<String, IndexedObject<?>> kv : info.information_.entrySet()) {
            if (kv.getValue().obj instanceof InformationSet) {
                InformationSet subset = this.subSet(kv.getKey());
                if (subset == null) {
                    return false;
                }
                subset.update((InformationSet)kv.getValue().obj);
                continue;
            }
            switch (kv.getKey()) {
                case "warnings": {
                    this.addMessages(WARNINGS, (String[])kv.getValue().obj);
                    continue block8;
                }
                case "errors": {
                    this.addMessages(ERRORS, (String[])kv.getValue().obj);
                    continue block8;
                }
            }
            this.information_.put(kv.getKey(), new IndexedObject(kv.getValue().obj));
        }
        return true;
    }

    public <S> boolean addLog(String name, S info) {
        return this.subSet(LOG).add(name, info);
    }

    public <S> boolean setLog(String name, S info) {
        return this.subSet(LOG).set(name, info);
    }

    public InformationSet getLog() {
        return this.getSubSet(LOG);
    }

    public static <T> T convert(Object obj, Class<T> tclass) {
        Class<?> oclass;
        if (obj == null) {
            return null;
        }
        if (tclass.isInstance(obj)) {
            return (T)obj;
        }
        if (tclass.isArray() && (oclass = obj.getClass()).isArray()) {
            int len = Array.getLength(obj);
            Object nobj = Array.newInstance(tclass.getComponentType(), len);
            try {
                System.arraycopy(obj, 0, nobj, 0, len);
                return (T)nobj;
            }
            catch (ArrayStoreException ex) {
                return null;
            }
        }
        return null;
    }

    static class IndexedObject<S> {
        final long index = curIndex.getAndIncrement();
        final S obj;
        private static final AtomicLong curIndex = new AtomicLong(0L);

        IndexedObject(S obj) {
            this.obj = obj;
        }
    }

    static class IndexedName
    implements Comparable<IndexedName> {
        final long index;
        final String name;
        private static final AtomicLong curIndex = new AtomicLong(0L);

        IndexedName(long idx, String name) {
            this.index = idx;
            this.name = name;
        }

        IndexedName(String name) {
            this.index = curIndex.getAndIncrement();
            this.name = name;
        }

        @Override
        public int compareTo(IndexedName o) {
            return Long.compare(this.index, o.index);
        }
    }
}

