% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RIM.R
\name{apply.RIM}
\alias{apply.RIM}
\title{Function to apply Reference Ideal Method (RIM)
Note:
function is rewritten from the MCDM package to match the formatting of the R RMCDA package
SOURCE: https://github.com/cran/MCDM/blob/master/R/RIM.R}
\usage{
apply.RIM(mat, weights, AB, CD)
}
\arguments{
\item{mat}{A matrix m x n containing the values of the m alternatives
for the n criteria.}

\item{weights}{A numeric vector of length n, containing the weights for the criteria.
The sum of the weights must be equal to 1.}

\item{AB}{A matrix (2 x n), where the first row of AB corresponds to the A extreme,
and the second row of AB corresponds to the B extreme of the domain (universe of discourse)
for each criterion.}

\item{CD}{A matrix (2 x n), where the first row of CD corresponds to the C extreme,
and the second row of CD corresponds to the D extreme of the ideal reference for each criterion.

Degenerate intervals:
\enumerate{
\item If the first element of AB matches the first element of CD, then the interval between A and C collapses to a point.
\itemize{
\item Any value x within this range is treated under a fallback rule:
\itemize{
\item If x equals both A and C, the normalized value is set to 1.
\item Otherwise, the normalized value is set to 0.
}
}
\item If the second element of CD matches the second element of AB, then the interval between D and B collapses to a point.
\itemize{
\item A similar fallback applies:
\itemize{
\item If x equals both D and B, the normalized value is set to 1.
\item Otherwise, the normalized value is set to 0.
}
}
}

These fallback rules ensure the function does not stop but, instead, issues a warning and assigns
a default. Adjust these defaults if your MCDM context requires different handling.}
}
\value{
A data frame containing:
\itemize{
\item Alternatives: The index of each alternative.
\item R: The R index (score) for each alternative.
\item Ranking: The ranking of the alternatives based on the R score.
}

Reference:
Cables, E.; Lamata, M.T.; Verdegay, J.L. (2016).
RIM-reference ideal method in multicriteria decision making.
Information Science, 337-338, 1-10.
}
\description{
The apply.RIM function implements the Reference Ideal Method (RIM) for
multi-criteria decision making (MCDM) problems, allowing for degenerate intervals,
i.e. cases where A == C or D == B.
}
\examples{

# Example decision matrix
mat <- matrix(
  c(30,40,25,27,45,0,
    9,0,0,15,2,1,
    3,5,2,3,3,1,
    3,2,3,3,3,2,
    2,2,1,4,1,2),
  nrow = 5, ncol = 6, byrow = TRUE
)

#Example weights vector (must sum to 1)
weights <- c(0.2262,0.2143,0.1786,0.1429,0.119,0.119)

#Example AB matrix
AB <- matrix(
  c(23,60,0,15,0,10,
    1,3,1,3,1,5),
  nrow = 2, ncol = 6, byrow = TRUE
)

#Example CD matrix
CD <- matrix(
  c(30,35,10,15,0,0,
    3,3,3,3,4,5),
  nrow = 2, ncol = 6, byrow = TRUE
)


apply.RIM(mat, weights, AB, CD)

}
