% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_roc.R
\name{add_fpauc_partially_proper_lower_bound}
\alias{add_fpauc_partially_proper_lower_bound}
\alias{add_fpauc_concave_lower_bound}
\alias{fpauc_lower_bounds}
\alias{add_fpauc_lower_bound}
\title{Add FpAUC lower bound to a ROC plot}
\usage{
add_fpauc_partially_proper_lower_bound(
  data,
  response = NULL,
  predictor = NULL,
  threshold,
  .condition = NULL,
  .label = NULL
)

add_fpauc_concave_lower_bound(
  data,
  response = NULL,
  predictor = NULL,
  threshold,
  .condition = NULL,
  .label = NULL
)

add_fpauc_lower_bound(
  data,
  response = NULL,
  predictor = NULL,
  threshold,
  .condition = NULL,
  .label = NULL
)
}
\arguments{
\item{data}{A data.frame or extension (e.g. a tibble) containing values for
predictors and response variables.}

\item{response}{A data variable which must be a factor, integer or character
vector representing the prediction outcome on each observation
(\emph{Gold Standard}).

If the variable presents more than two possible outcomes, classes or
categories:
\itemize{
\item The outcome of interest (the one to be predicted) will remain distinct.
\item All other categories will be combined into a single category.
}

New combined category represents the "absence" of the condition to predict.
See \code{.condition} for more information.}

\item{predictor}{A data variable which must be numeric, representing values
of a classifier or predictor for each observation.}

\item{threshold}{A number between 0 and 1, inclusive. This number represents
the lower value of TPR for the region where to calculate and plot
lower bound.

Because of definition of \code{\link[=fp_auc]{fp_auc()}}, region upper bound will be established
as 1.}

\item{.condition}{A value from response that represents class, category or
condition of interest which wants to be predicted.

If \code{NULL}, condition of interest will be selected automatically depending on
\code{response} type.

Once the class of interest is selected, rest of them will be collapsed in a
common category, representing the "absence" of the condition to be predicted.

See \code{vignette("selecting-condition")} for further information on how
automatic selection is performed and details on selecting the condition of
interest.}

\item{.label}{A string representing the name used in labels.

If \code{NULL}, variable name from \code{predictor} will be used as label.}
}
\value{
A ggplot layer instance object.
}
\description{
Calculate and plot lower bound defined by FpAUC sensitivity index.
\itemize{
\item \code{add_fpauc_lower_bound()} provides an upper level function which
automatically calculates curve shape and plots a lower bound that better fits
it.
\item \code{add_fpauc_partially_proper_lower_bound()} and
\code{add_fpauc_concave_lower_bound()} are lower level functions that enforce the
plot of specific bounds.
}

First one plots lower bound when curve shape is
partially proper (presents some kind of hook). Second one plots lower bound
when curve shape is concave in the region of interest.
}
\examples{
# Add lower bound based on curve shape (Concave)
plot_roc_curve(iris, response = Species, predictor = Sepal.Width) +
  add_fpauc_lower_bound(
    data = iris,
    response = Species,
    predictor = Sepal.Width,
    threshold = 0.9
  )
}
