% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resampleTree.R
\name{resampleTree}
\alias{resampleTree}
\title{Altering phylogenetic trees}
\usage{
resampleTree(tree,s=0.25,sdata=NULL,nodes=NULL,categories=NULL,
             swap.si=0.1,swap.si2=0.1,swap.node=NULL,nsim=1)
}
\arguments{
\item{tree}{a phylogenetic tree. The tree needs not to be ultrametric or
fully dichotomous.}

\item{s}{the percentage of tips to be cut off. It is set at 25\% by default.}

\item{sdata}{to be supplied to condition the species sampling. It can be
either a named vector or a data.frame/matrix having the species names as
first column. In case of stratified random sampling, \code{sdata} should
contain the strata. Otherwise, the user can provide a sampling probability
(meant as the probability to be removed from the tree) for each species.}

\item{nodes}{the clades to be preserved. In this case the function maintains
no less than 5 species at least in each of them.}

\item{categories}{the categories to be preserved. In this case the function
maintains no less than 5 species at least in each of them.}

\item{swap.si, swap.si2, swap.node}{arguments \code{si, si2, node} as passed to
\code{\link{swapONE}}. The default for both \code{si} and \code{si2} is
0.1.}

\item{nsim}{number of phylogenies to return. It is set at 1 by default.}
}
\value{
The function returns \code{phylo} or \code{multiPhylo} object.
The output always has an attribute "Call" which returns an unevaluated call to the function.
}
\description{
The function alters the topology and randomly removes a
  user-specified proportion of species from a phylogenetic tree.
}
\examples{
\dontrun{
DataCetaceans$treecet->treecet
plot(treecet,show.tip.label = FALSE,no.margin = TRUE)
nodelabels(frame="n",col="red")

# Select two clades for stratified random sampling
clanods=c("crown_Odo"=150,"crown_Mysti"=131)
sdata1<-do.call(rbind,lapply(1:length(clanods),function(w)
  data.frame(species=tips(treecet,clanods[w]),group=names(clanods)[w])))

# generate a vector of probabilities based on body mass
prdata<-max(DataCetaceans$masscet)-DataCetaceans$masscet

# select two nodes to be preserved
nn=c(180,159)

# generate two fictional categorical vectors to be preserved
cat1<-sample(rep(c("a","b","c"),each=39),Ntip(treecet))
names(cat1)<-treecet$tip.label
cat2<-rep(c("d","e"),each=100)
names(cat2)<-sample(treecet$tip.label,100)

# 1. Random sampling
resampleTree(treecet,s=0.25,swap.si=0.3)->treecet1

# 1.1 Random sampling preserving clades
resampleTree(treecet,s=0.25,nodes=nn)->treecet2

# 2. Stratified random sampling
resampleTree(treecet,sdata = sdata1,s=0.25)->treecet3

# 2.1 Stratified random sampling preserving clades and categories
resampleTree(treecet,sdata = sdata1,s=0.25,nodes=nn,categories = list(cat1,cat2))->treecet4

# 3. Sampling conditioned on probability
resampleTree(treecet,sdata = prdata,s=0.25,nsim=5)->treecet5
}
}
\seealso{
\href{../doc/search.conv.html}{\code{search.conv} vignette};
\href{../doc/overfitRR.html}{\code{overfitRR} vignette};
\href{../doc/Alternative-trees.html}{\code{Alternative-trees} vignette}
}
\author{
Silvia Castiglione, Giorgia Girardi
}
