% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genpois.R
\name{genpois}
\alias{genpois}
\alias{dgenpois}
\alias{pgenpois}
\alias{qgenpois}
\alias{rgenpois}
\title{Generalised Poisson distribution}
\usage{
dgenpois(x, lambda = 1, phi = 1, log = FALSE)

pgenpois(q, lambda = 1, phi = 1, lower.tail = TRUE, log.p = FALSE)

qgenpois(p, lambda = 1, phi = 1,
         lower.tail = TRUE, log.p = FALSE, max.value = 10000)

rgenpois(n, lambda = 1, phi = 1, max.value = 10000)
}
\arguments{
\item{x, q}{integer vector of counts}

\item{lambda}{vector of positive means}

\item{phi}{vector of non-negative dispersion parameters}

\item{log, log.p}{logical; return log-density if TRUE}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities}

\item{max.value}{a constant, set to the default value of 10000 for how far the algorithm should look for \code{q}.}

\item{n}{number of random values to return.}
}
\value{
\code{dgenpois} gives the probability mass function, \code{pgenpois} gives the distribution function, \code{qgenpois} gives the quantile function, and \code{rgenpois} generates random deviates.
}
\description{
Probability mass function, distribution function, and random generation for
the generalised Poisson distribution.
}
\details{
This implementation of \code{dgenpois} allows for automatic differentiation with \code{RTMB}.
The other functions are imported from \code{gamlss.dist::GPO}.

The distribution has mean \eqn{\lambda} and variance \eqn{\lambda(1 + \phi \lambda)^2}.
For \eqn{\phi = 0} it reduces to the Poisson distribution, however \eqn{\phi} must be strictly positive here.
}
\examples{
set.seed(123)
x <- rgenpois(1, 2, 3)
d <- dgenpois(x, 2, 3)
p <- pgenpois(x, 2, 3)
q <- qgenpois(p, 2, 3)
}
