% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerexp.R
\name{powerexp}
\alias{powerexp}
\alias{dpowerexp}
\alias{ppowerexp}
\alias{qpowerexp}
\alias{rpowerexp}
\alias{dpowerexp2}
\alias{ppowerexp2}
\alias{qpowerexp2}
\alias{rpowerexp2}
\title{Power Exponential distribution (PE and PE2)}
\usage{
dpowerexp(x, mu = 0, sigma = 1, nu = 2, log = FALSE)

ppowerexp(q, mu = 0, sigma = 1, nu = 2, lower.tail = TRUE, log.p = FALSE)

qpowerexp(p, mu = 0, sigma = 1, nu = 2, lower.tail = TRUE, log.p = FALSE)

rpowerexp(n, mu = 0, sigma = 1, nu = 2)

dpowerexp2(x, mu = 0, sigma = 1, nu = 2, log = FALSE)

ppowerexp2(q, mu = 0, sigma = 1, nu = 2, lower.tail = TRUE, log.p = FALSE)

qpowerexp2(p, mu = 0, sigma = 1, nu = 2, lower.tail = TRUE, log.p = FALSE)

rpowerexp2(n, mu = 0, sigma = 1, nu = 2)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{mu}{location parameter}

\item{sigma}{scale parameter, must be positive}

\item{nu}{shape parameter (real)}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities are \eqn{P[X \le x]}, otherwise \eqn{P[X > x]}}

\item{p}{vector of probabilities}

\item{n}{number of random values to return}
}
\value{
\code{dpowerexp} gives the density, \code{ppowerexp} gives the distribution function, \code{qpowerexp} gives the quantile function, and \code{rpowerexp} generates random deviates.
}
\description{
Density, distribution function, quantile function, and random generation for
the Power Exponential distribution (two versions).
}
\details{
This implementation of the densities and distribution functions allow for automatic differentiation with \code{RTMB} while the other functions are imported from \code{gamlss.dist} package.

For \code{powerexp}, \code{mu} is the mean and \code{sigma} is the standard deviation while this does not hold for \code{powerexp2}.

See \code{gamlss.dist::\link[gamlss.dist]{PE}} for more details.
}
\examples{
# PE
x <- rpowerexp(1, mu = 0, sigma = 1, nu = 2)
d <- dpowerexp(x, mu = 0, sigma = 1, nu = 2)
p <- ppowerexp(x, mu = 0, sigma = 1, nu = 2)
q <- qpowerexp(p, mu = 0, sigma = 1, nu = 2)

# PE2
x <- rpowerexp2(1, mu = 0, sigma = 1, nu = 2)
d <- dpowerexp2(x, mu = 0, sigma = 1, nu = 2)
p <- ppowerexp2(x, mu = 0, sigma = 1, nu = 2)
q <- qpowerexp2(p, mu = 0, sigma = 1, nu = 2)
}
\references{
Rigby, R. A., Stasinopoulos, D. M., Heller, G. Z., and De Bastiani, F. (2019) Distributions for modeling location, scale, and shape: Using GAMLSS in R, Chapman and Hall/CRC,
doi:10.1201/9780429298547. An older version can be found in https://www.gamlss.com/.
}
