% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lag_df.R
\name{lag_df}
\alias{lag_df}
\title{lag_df}
\usage{
lag_df(df, laglist)
}
\arguments{
\item{df}{A data.frame or \code{tibble}.}

\item{laglist}{A list of column names where each index corresponds to a column
name and the associated value is the lag sequence.}
}
\value{
\code{tibble}
}
\description{
The \code{lag_df} function creates additional columns based on a list of column names
and lag sequences. This feature is beneficial for scenarios where you need
varying lag selections for certain columns, allowing flexibility in specifying
different lags for different columns or opting for no lag at all.
}
\examples{
df <- data.frame(a = 1:15, b = 2:16)
tb <- lag_df(df, laglist = list(a = 1:5, b = 1:3))
}
