% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdb.R
\name{exclude_irrelevant_findings}
\alias{exclude_irrelevant_findings}
\alias{blacklist_vague_findings}
\alias{blacklist_almost_all_except_diseases}
\title{Sample inclusion, exclusion and blacklist sets for a MiADE CDB}
\usage{
exclude_irrelevant_findings(SNOMED = getSNOMED())

blacklist_vague_findings(SNOMED = getSNOMED())

blacklist_almost_all_except_diseases(SNOMED = getSNOMED())
}
\arguments{
\item{SNOMED}{environment containing a SNOMED dictionary}
}
\value{
SNOMEDconcept vector containing findings to exclude
}
\description{
Returns a set of SNOMED concepts (as a SNOMEDconcept vector)
which can be used to exclude
findings in the MedCAT named entity recognition step, or blacklist
(filter out) findings from the final output.
}
\details{
\describe{
  \item{exclude_irrelevant_findings}{social history 
     (except housing problems and care needs),
     administrative statuses (except registered disabled) and
     for concept detection}
  \item{blacklist_vague_findings}{vague findings and disorders,
     intended to be used in the blacklist}
  \item{blacklist_almost_all_except_diseases}{almost all findings
     and vague disorders, intended to be used in the blacklist}
}
}
\seealso{
exportMiADECDB, createCDB

Other MiADE functions: 
\code{\link{exportMiADECDB}()}

Other MiADE functions: 
\code{\link{exportMiADECDB}()}

Other MiADE functions: 
\code{\link{exportMiADECDB}()}
}
\concept{MiADE functions}
