% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htmlCodelistHierarchy.R
\name{htmlCodelistHierarchy}
\alias{htmlCodelistHierarchy}
\title{Export a SNOMEDcodelist hierarchy to HTML}
\usage{
htmlCodelistHierarchy(
  x,
  file = NULL,
  title = NULL,
  description = NULL,
  extracols = NULL,
  SNOMED = getSNOMED(),
  ...
)
}
\arguments{
\item{x}{a SNOMEDcodelist, codelistHierarchy (output of
showCodelistHierarchy), or an object which can be coerced to
a SNOMEDcodelist (such as a SNOMEDconcept vector).}

\item{file}{filename to export to. If NULL, no file is written}

\item{title}{title of HTML document}

\item{description}{paragraph of description text (excluding
<p></p> tags)}

\item{extracols}{character vector of additional columns of 
codelist_with_hierarchy to include in HTML output}

\item{SNOMED}{environment containing the SNOMED dictionary to use}

\item{...}{extra arguments to pass to as.SNOMEDcodelist}
}
\value{
a character vector containing HTML output
}
\description{
Exports a codelist with hierarchy as HTML for easy viewing.
}
\examples{
data.table::setDTthreads(threads = 1) # for CRAN testing
SNOMED <- sampleSNOMED() # use sample SNOMED for testing

my_concepts <- SNOMEDconcept('Acute heart failure')
my_codelist <- SNOMEDcodelist(data.frame(conceptId = my_concepts,
  include_desc = TRUE))
my_codelist <- getMaps(my_codelist, to = 'icd10')
htmlCodelistHierarchy(my_codelist, file = paste0(tempdir(),
  '/codelist.html'), extracols = 'icd10_code')
# The codelist.html file can now be viewed in a web browser

# Clean up temporary file
file.remove(paste0(tempdir(), '/codelist.html'))
}
\seealso{
showCodelistHierarchy
}
