% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleSizeEdgington.R
\name{sampleSizeEdgington}
\alias{sampleSizeEdgington}
\title{Computes the required relative sample size to achieve replication success
with Edgington's method based on power}
\usage{
sampleSizeEdgington(
  zo = NULL,
  po = NULL,
  r = 1,
  power,
  level = 0.025,
  designPrior = "conditional",
  shrinkage = 0
)
}
\arguments{
\item{zo}{Numeric vector of z-values from original studies.}

\item{po}{Numeric vector of original one-sided p-values}

\item{r}{Numeric vector of ratios of replication to original weight.}

\item{power}{Power to achieve replication success.}

\item{level}{One-sided significance level. Default is 0.025.}

\item{designPrior}{Either "conditional" (default) or "predictive".}

\item{shrinkage}{Numeric vector with values in [0,1). Defaults to 0.
Specifies the shrinkage of the original effect estimate towards zero,
e.g., the effect is shrunken by a factor of 25\% for \code{shrinkage =
0.25}. Is only taken into account if the \code{designPrior} is
"conditional" or "predictive".}
}
\value{
The relative sample size to achieve replication success with
    Edgington's method. If impossible to achieve the desired power for
    specified inputs \code{NaN} is returned.
}
\description{
The relative sample size to achieve replication success with Edgington's
method is computed based on the z-value (or one-sided p-value) of the
original study, the significance level, the ratio of the weight of the
replication study over the weight of the original study, the design prior and
the power.
}
\details{
Either \code{zo} or \code{po} must be specified.
}
\examples{
## partially recreate Figure 5 from paper
poseq <- exp(seq(log(0.00001), log(0.025), length.out = 100))
cseq <- sampleSizeEdgington(po = poseq, power = 0.8)
cseqSig <- sampleSizeSignificance(zo = p2z(p = poseq, alternative = "one.sided"),
                                  power = 0.8)
plot(poseq, cseq/cseqSig, log = "x", xlim = c(0.00001, 0.035), ylim = c(0.9, 1.3),
     type = "l", las = 1, xlab = "Original p-value", ylab = "Sample size ratio")
}
\references{
Held, L., Pawel, S., Micheloud, C. (2024). The assessment of
    replicability using the sum of p-values. \emph{Royal Society Open
    Science}. 11(8):11240149. \doi{10.1098/rsos.240149}
}
\author{
Charlotte Micheloud, Leonhard Held, Samuel Pawel
}
