% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{coef.RiskMap}
\alias{coef.RiskMap}
\title{Extract Parameter Estimates from a "RiskMap" Model Fit}
\usage{
\method{coef}{RiskMap}(object, ...)
}
\arguments{
\item{object}{An object of class "RiskMap" obtained as a result of a call to \code{\link{glgpm}}.}

\item{...}{other parameters.}
}
\value{
A list containing the maximum likelihood estimates:
\item{beta}{A vector of coefficient estimates.}
\item{sigma2}{The estimate for the variance parameter \eqn{\sigma^2}.}
\item{phi}{The estimate for the spatial range parameter \eqn{\phi}.}
\item{tau2}{The estimate for the nugget effect parameter \eqn{\tau^2}, if applicable.}
\item{sigma2_me}{The estimate for the measurement error variance \eqn{\sigma^2_{me}}, if applicable.}
\item{sigma2_re}{A vector of variance estimates for the random effects, if applicable.}
}
\description{
This \code{coef} method for the "RiskMap" class extracts the
maximum likelihood estimates from model fits obtained from the \code{\link{glgpm}} function.
}
\details{
The function processes the \code{RiskMap} object to extract and name the estimated parameters appropriately, transforming them if necessary.
}
\note{
This function handles both Gaussian and non-Gaussian families, and accounts for fixed and random effects in the model.
}
\seealso{
\code{\link{glgpm}}
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Claudio Fronterre \email{c.fronterr@lancaster.ac.uk}
}
