% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-harmo_process_harmonization.R
\name{pooled_harmonized_dataset_create}
\alias{pooled_harmonized_dataset_create}
\title{Generate a pooled harmonized dataset from a harmonized dossier}
\usage{
pooled_harmonized_dataset_create(
  harmonized_dossier,
  harmonized_col_dataset =
    attributes(harmonized_dossier)$`Rmonize::harmonized_col_dataset`,
  harmonized_col_id = attributes(harmonized_dossier)$`Rmonize::harmonized_col_id`,
  dataschema = attributes(harmonized_dossier)$`Rmonize::DataSchema`,
  data_proc_elem = attributes(harmonized_dossier)$`Rmonize::Data Processing Elements`
)
}
\arguments{
\item{harmonized_dossier}{A list containing the harmonized dataset(s).}

\item{harmonized_col_dataset}{A character string identifying the column
to use for dataset names.}

\item{harmonized_col_id}{A character string identifying the name of the
column present in every dataset to use as a participant identifier.}

\item{dataschema}{A DataSchema object.}

\item{data_proc_elem}{A Data Processing Elements object.}
}
\value{
A data frame containing the pooled harmonized dataset.
}
\description{
Generates a pooled harmonized dataset from a harmonized dossier. The function
has two arguments that can optionally be declared by the user
(\code{harmonized_col_dataset} and \code{harmonized_col_id}). \code{harmonized_col_dataset}
refers to the columns which contains name of each harmonized dataset.
\code{harmonized_col_id} refers to the column in harmonized datasets which
identifies unique combinations of observation/dataset. These two columns are
added to ensure that there is always a unique entity identifier when datasets
are pooled.
}
\details{
A harmonized dossier is a named list containing one or more data frames,
which are harmonized datasets. A harmonized dossier is generally the
product of applying processing to a dossier object The name of each
harmonized dataset (data frame) is taken from the reference input dataset.
A harmonized dossier also contains the DataSchema and
Data Processing Elements used in processing as attributes.

A DataSchema is the list of core variables to generate across datasets and
related metadata. A DataSchema object is a list of data frames with elements
named 'Variables' (required) and 'Categories' (if any). The 'Variables'
element must contain at least the \code{name} column, and the 'Categories'
element must contain at least the \code{variable} and \code{name} columns to be usable
in any function. In 'Variables' the \code{name} column must also have unique
entries, and in 'Categories' the combination of \code{variable} and \code{name} columns
must also be unique.

The Data Processing Elements specifies the input elements and processing algorithms
to generate harmonized variables in the DataSchema formats. It is also
contains metadata used to generate documentation of the processing.
A Data Processing Elements object is a data frame with specific columns
used in data processing: \code{dataschema_variable}, \code{input_dataset},
\code{input_variables}, \code{Mlstr_harmo::rule_category} and \code{Mlstr_harmo::algorithm}.
To initiate processing, the first entry must be the creation of a harmonized
primary identifier variable (e.g., participant unique ID).
}
\examples{
{

# Use Rmonize_examples to run examples.
 
library(dplyr)

# Perform data processing
harmonized_dossier <- Rmonize_examples["harmonized_dossier"][[1]]

# create the pooled harmonized dataset from the harmonized dossier
pooled_harmonized_dataset <- pooled_harmonized_dataset_create(harmonized_dossier)
  
glimpse(pooled_harmonized_dataset)
  
}

}
