% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuneandtrainIntRF.R
\name{tuneandtrainIntRF}
\alias{tuneandtrainIntRF}
\title{Tune and Train Internal Random Forest}
\usage{
tuneandtrainIntRF(data, num.trees = 500, nfolds = 5, seed = 123)
}
\arguments{
\item{data}{A data frame containing the training data. The first column should be the response variable (factor), 
and the remaining columns should be the predictor variables.}

\item{num.trees}{An integer specifying the number of trees in the Random Forest. Default is 500.}

\item{nfolds}{An integer specifying the number of folds for cross-validation. Default is 5.}

\item{seed}{An integer specifying the random seed for reproducibility. Default is 123.}
}
\value{
A list containing the best `min.node.size` value (`best_min_node_size`) and
  the final trained model (`best_model`).
}
\description{
This function tunes and trains a Random Forest classifier using the \code{ranger} package with internal cross-validation. 
The function evaluates a sequence of \code{min.node.size} values on the training dataset and selects 
the best model based on the Area Under the Curve (AUC).
}
\details{
Random Forest constructs multiple decision trees and aggregates their predictions. 
The \code{min.node.size} parameter controls the minimum number of samples in each terminal node, affecting model complexity. 
This function performs cross-validation within the training dataset to evaluate the impact of different \code{min.node.size} values. 
The \code{min.node.size} value that results in the highest AUC is selected as the best model.
}
\examples{
\donttest{
# Load sample data
data(sample_data_train)

# Example usage
result <- tuneandtrainIntRF(sample_data_train, num.trees = 500, nfolds = 5, seed = 123)
result$best_min_node_size
result$best_model
}
}
