% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findAvgSurface.R
\name{findAvgSurface}
\alias{findAvgSurface}
\title{Find the average surface level}
\usage{
findAvgSurface(
  img_paths = NULL,
  imgs = NULL,
  surface_col = "red",
  pos_highpoint_px = "center",
  radius_highpoint_px = 10,
  angle = 45,
  top_side = "left",
  ppcm = NULL,
  ppi = NULL
)
}
\arguments{
\item{img_paths}{(Optional, default = NULL) Character vector specifying all
of the individual image paths of interest. This is only used if
\code{imgs} is set to NULL.}

\item{imgs}{List of images (e.g., provided by the RootDetector). Each image
can be a PNG, i.e., an array with 3 dimensions (3 layers each containing a
2-dim. numeric matrix with values between 0 and 1), or a 2-dim. matrix.}

\item{surface_col}{Color of the area to be split of the mask (default "red").
Can be of any of the three kinds of R color specifications, i.e., either a
color name (as listed by colors()), a hexadecimal string (see Details), or a
positive integer (indicates using palette()).}

\item{pos_highpoint_px}{Either one of "center" or "edge" (default),
indicating that scanning starts at the bottom or top facing side of the
minirhizotron, respectively, or it can also be an integer value (>=1 and
<=width of the \code{top_side} of the image) specifying where (left<->right)
in the top row of the image the highest point of the image lies, indicating
the column where the minimum points of the depth-level lines lie. \cr
"edge" is equivalent to using 1 or width of the \code{top_side} and
"center" to using half the width of the \code{top_side}.}

\item{radius_highpoint_px}{The radius specifying how large the are should be
to determine the split (default 10).}

\item{angle}{Numeric value >=0 and <=90 (default 45) specifying the
installation angle of the minirhizotron in degrees (angle between the ground
and the tube above the soil).}

\item{top_side}{One of "left","top" (default),"right","bottom". Indicates
where the upper side of the image is.}

\item{ppcm}{Numeric value specifying how many pixels there are per
centimeter (resolution of the image). Default NULL.
If \code{ppcm} is not NULL or NA, \code{ppi} is ignored.\cr
Examples: 300 ppi (printing) is 118 ppcm, 150 ppi is 59 ppcm,
72 ppi (screens) is 28 ppcm.}

\item{ppi}{Numeric value specifying how many pixels there are per inch
(resolution of the image). Default NULL.
Leave/set \code{ppcm} to NULL or NA to use \code{ppi}.\cr
Examples: 300 ppi (printing) is 118 ppcm, 150 ppi is 59 ppcm,
72 ppi (screens) is 28 ppcm.}
}
\value{
\code{findAvgSurface} A list with the two values
'pos_surf_px' and 'depth_highpoint_cm', and a matrix
'all_split_info' containing the information on all possible splits.
}
\description{
\code{findAvgSurface} - This function looks at several images which
should have the same surface level, for example the root scans (topmost
depth window) of the same minirhizotron. Then, the best position of the
surface level is determined by finding the best across all images.
}
\examples{
# Example of finding the best overlap of two sets of two matrices.
mat_R <- matrix(c(1,1,1,1,1,
                  0,1,1,1,1,
                  0,0,1,1,1), ncol = 5, nrow = 3, byrow = TRUE)
mat_G <- matrix(c(0,0,0,0,1,
                  0,1,0,0,1,
                  0,0,1,1,1), ncol = 5, nrow = 3, byrow = TRUE)
mat_G2 <- matrix(c(0,0,0,1,0,
                   0,0,0,0,0,
                   0,0,1,1,1), ncol = 5, nrow = 3, byrow = TRUE)
mat_B <- matrix(c(0,0,0,0,1,
                  0,0,0,0,1,
                  0,0,1,1,1), ncol = 5, nrow = 3, byrow = TRUE)
mat_B2 <- matrix(c(0,0,0,0,0,
                   0,1,0,0,1,
                   0,0,1,1,1), ncol = 5, nrow = 3, byrow = TRUE)
surface <- findAvgSurface(imgs = list(
                  array(c(mat_R,mat_G,mat_B), dim = c(dim(mat_R),3)),
                  array(c(mat_R,mat_G2,mat_B), dim = c(dim(mat_R),3)),
                  array(c(mat_R,mat_G,mat_B2), dim = c(dim(mat_R),3))),
                         radius_highpoint_px = 2, top_side = "top", ppcm = 1)
}
