% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_prior.R
\name{check_prior}
\alias{check_prior}
\title{Check prior parameters}
\usage{
check_prior(
  P_f,
  P_r,
  J,
  ordered = FALSE,
  mu_alpha_0 = numeric(P_f),
  Sigma_alpha_0 = 10 * diag(P_f),
  delta = 1,
  mu_b_0 = numeric(P_r),
  Sigma_b_0 = 10 * diag(P_r),
  n_Omega_0 = P_r + 2,
  V_Omega_0 = diag(P_r),
  n_Sigma_0 = J + 1,
  V_Sigma_0 = diag(J - 1),
  mu_d_0 = numeric(J - 2),
  Sigma_d_0 = diag(J - 2)
)
}
\arguments{
\item{P_f}{[\code{integer(1)}]\cr
The number of covariates connected to a fixed coefficient.}

\item{P_r}{[\code{integer(2)}]\cr
The number of covariates connected to a random coefficient.}

\item{J}{[\code{integer(1)}]\cr
The number >= 2 of choice alternatives.}

\item{ordered}{[\code{logical(1)}]\cr
If \code{TRUE}, the choice set \code{alternatives} is assumed to be ordered
from worst to best.}

\item{mu_alpha_0}{[\code{numeric(P_f)}]\cr
The mean vector of the normal prior for \code{alpha}.}

\item{Sigma_alpha_0}{[\code{matrix(P_f, P_f)}]\cr
The covariance matrix of the normal prior for \code{alpha}.}

\item{delta}{[\code{numeric(1)}]\cr
The prior concentration for \code{s}.}

\item{mu_b_0}{[\code{numeric(P_r)}]\cr
The mean vector of the normal prior for each \code{b_c}.}

\item{Sigma_b_0}{[\code{matrix(P_r, P_r)}]\cr
The covariance matrix of the normal prior for each \code{b_c}.}

\item{n_Omega_0}{[\code{integer(1)}]\cr
The degrees of freedom of the Inverse Wishart prior for each \code{Omega_c}.}

\item{V_Omega_0}{[\code{matrix(P_r, P_r)}]\cr
The scale matrix of the Inverse Wishart prior for each \code{Omega_c}.}

\item{n_Sigma_0}{[\code{integer(1)}]\cr
The degrees of freedom of the Inverse Wishart prior for \code{Sigma}.}

\item{V_Sigma_0}{[\code{matrix(J - 1, J - 1)}]\cr
The scale matrix of the Inverse Wishart prior for \code{Sigma}.}

\item{mu_d_0}{[\code{numeric(J - 2)}]\cr
The mean vector of the normal prior for \code{d} .}

\item{Sigma_d_0}{[\code{matrix(J - 2, J - 2)}]\cr
The covariance matrix of the normal prior for \code{d}.}
}
\value{
An object of class \code{RprobitB_prior}, which is a \code{list} containing all
prior parameters.
}
\description{
This function checks the compatibility of submitted parameters for the prior
distributions and sets missing values to default values.
}
\details{
A priori-distributions:
\itemize{
\item \eqn{\alpha \sim N(\mu_{\alpha_0}, \Sigma_{\alpha_0})}
\item \eqn{s \sim Dir(\delta)}
\item \eqn{b_c \sim N(\mu_{b_0}, \Sigma_{b_0})} for all \eqn{c}
\item \eqn{\Omega_c \sim IW(n_{\Omega_0}, V_{\Omega_0})} for all \eqn{c}
\item \eqn{\Sigma \sim IW(n_{\Sigma_0}, V_{\Sigma_0})}
\item \eqn{d \sim N(\mu_{d_0}, \Sigma_{d_0})}
}
}
\examples{
check_prior(P_f = 1, P_r = 2, J = 3, ordered = TRUE)
}
