% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing_covariates.R
\name{missing_covariates}
\alias{missing_covariates}
\title{Handle missing covariates}
\usage{
missing_covariates(
  choice_data,
  impute = "complete_cases",
  col_ignore = character()
)
}
\arguments{
\item{choice_data}{[\code{data.frame}]\cr
Choice data in wide format, where each row represents one choice occasion.}

\item{impute}{A character that specifies how to handle missing covariate entries in
\code{choice_data}, one of:
\itemize{
\item \code{"complete_cases"}, removes all rows containing missing
covariate entries (the default),
\item \code{"zero"}, replaces missing covariate entries by zero
(only for numeric columns),
\item \code{"mean"}, imputes missing covariate entries by the mean
(only for numeric columns).
}}

\item{col_ignore}{A character vector of columns that are ignored (none per default).}
}
\value{
The input \code{choice_data}, in which missing covariates are addressed.
}
\description{
This function checks for and replaces missing covariate entries in
\code{choice_data}.
}
\keyword{internal}
