% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastx_combine_files.R
\name{fastx_combine_files}
\alias{fastx_combine_files}
\alias{fastq_combine_files}
\alias{fasta_combine_files}
\title{Combine FASTA/FASTQ files in a directory into a single file or object}
\usage{
fastx_combine_files(
  files_dir,
  output_file = NULL,
  file_ext = ".fq",
  file_format = "fastq",
  tmpdir = NULL
)
}
\arguments{
\item{files_dir}{(Required). A character string specifying the path to the
directory containing the files to be combined. Files must be uncompressed.}

\item{output_file}{(Optional). A character string specifying the name of the
output file. If \code{NULL} (default), the combined data is returned as a
FASTA/FASTQ object depending on \code{file_format} instead of being written
to a file.}

\item{file_ext}{(Optional). File extension of the files to be combined.
Defaults to \code{".fq"}.}

\item{file_format}{(Optional). Format of files to be combined and the desired
output format: either \code{"fasta"} or \code{"fastq"} (default). See
\emph{Details}.}

\item{tmpdir}{(Optional). Path to the directory where temporary files should
be written when tables are used as input or output. Defaults to
\code{NULL}, which resolves to the session-specific temporary directory
(\code{tempdir()}).}
}
\value{
A tibble or \code{NULL}.

If \code{output_file} is specified, the combined sequences are written to the
specified file.

If \code{output_file} is \code{NULL}, the combined sequences are returned as
a tibble in the format specified by \code{file_format}.
}
\description{
\code{fastx_combine_files} combines all FASTA or FASTQ files
within a specified directory into a single output file or a tibble object.
}
\details{
\code{files_dir} must contain uncompressed FASTA or FASTQ files matching the
specified \code{file_ext}.

All files with the specified \code{file_ext} in \code{files_dir} are
concatenated into a single output file or tibble.

A FASTA object is a tibble containing the columns \code{Header} and
\code{Sequence}.
A FASTQ object is a tibble containing the columns \code{Header},
\code{Sequence}, and \code{Quality}.

If \code{output_file} is specified, the combined sequences are written to
this file in the format specified by \code{file_format}.

If \code{output_file} is \code{NULL}, the combined sequences are returned as
a tibble in the format specified by \code{file_format}, and no file is
written.
}
\examples{
# Define arguments
files_dir <- system.file("extdata", package = "Rsearch")
output_file <- NULL
file_ext <- ".fq"
file_format <- "fastq"

# Combine files and return tibble object
combined_files <- fastx_combine_files(files_dir = files_dir,
                                      output_file = output_file,
                                      file_ext = file_ext,
                                      file_format = file_format)

# Combine files and write to output file

# Define output file name
out <- tempfile(fileext = ".fastq")

fastx_combine_files(files_dir = files_dir,
                    output_file = out,
                    file_ext = file_ext,
                    file_format = file_format)
\dontshow{unlink(out)}

}
