% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ee_rate_dist.R
\name{plot_ee_rate_dist}
\alias{plot_ee_rate_dist}
\title{Plot distribution of expected error (EE) rate of reads}
\usage{
plot_ee_rate_dist(
  fastq_input,
  n_bins = 30,
  plot_title = "Distribution of the expected error (EE) rate of reads"
)
}
\arguments{
\item{fastq_input}{(Required). A FASTQ file path or FASTQ object containing
reads. See \emph{Details}.}

\item{n_bins}{(Optional). Number of bins used in the histogram. Defaults to
\code{30}, which is the default value in \code{ggplot2::geom_histogram()}.}

\item{plot_title}{(Optional). The title of the plot. Defaults to
\code{"Distribution of the expected error (EE) rate of reads"}. Set to
\code{""} for no title.}
}
\value{
A ggplot2 object displaying the histogram of EE rate distribution.
}
\description{
Generates a histogram visualizing the distribution of the expected error (EE)
rate for reads. The EE rate represents the cumulative probability of errors
in a read, calculated from Phred quality scores.
}
\details{
A histogram is plotted using ggplot2 to visualize the distribution of EE
rates. The user can adjust the number of bins in the histogram using the
\code{n_bins} parameter.

\code{fastq_input} can either be a file path to a FASTQ file or a FASTQ
object. FASTQ objects are tibbles that contain the columns \code{Header},
\code{Sequence}, and \code{Quality}, see \code{\link[microseq]{readFastq}}.

The EE rate is calculated as the sum of error probabilities per read, where
the error probability for each base is computed as \eqn{10^{(-Q/10)}} from
Phred scores. A lower EE rate indicates higher sequence quality, while a
higher EE rate suggests lower confidence in the read.

If \code{fastq_input} contains more than 10 000 reads, the function will
randomly select 10 000 rows for downstream calculations. This subsampling is
performed to reduce computation time and improve performance on large
datasets.
}
\examples{
# Define input file path
fastq_input <- system.file("extdata/small_R1.fq", package = "Rsearch")

# Generate and display histogram
ee_plot <- plot_ee_rate_dist(fastq_input = fastq_input)
print(ee_plot)

}
