% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rpower}
\alias{rpower}
\title{Generates a random sample from a Exponential Power distribution}
\usage{
rpower(n, m = 0, a = 1, b = 2)
}
\arguments{
\item{n}{(int) - size of the sample.}

\item{m}{(numeric) - the location parameter.}

\item{a}{(numeric) - scale parameter.}

\item{b}{(numeric) - shape parameter.}
}
\value{
a numeric vector containing a random sample with above parameters.
}
\description{
Returns a sample from a gamma-distributed random variable.
}
\details{
The exponential power distribution (EP) is given by the function:
\deqn{ f(a,b) = \frac{1}{2a\Gamma(1+1/b)}e^{-|x/a|^b}, -\infty < x < \infty }.
where \eqn{b} is a shape parameter, \eqn{a} is a scale parameter and \eqn{\Gamma}
represents the gamma function. While not done here, the distribution can
be adapted to have non-zero location parameter.
The Exponential Power distribution is related to the gamma distribution by
the equation:
\deqn{E = a*G(1/b)^{1/b}}
where E and G are respectively EP and gamma random variables. This property
is used for cases where \eqn{b<1} and \eqn{b>4}. For \eqn{1 \leq b \leq 4}
rejection methods based on the Laplace and normal distributions are used,
which should be faster.
Technical details about this algorithm are available on:
P. R. Tadikamalla, "Random Sampling from the Exponential Power
Distribution", Journal of the American Statistical Association,
September 1980, Volume 75, Number 371, pages 683-686.
The code is based on the original 'GSL' version, adapted to
use 'R' version of RNGs by Elias Haddad. All credits to the original authors.
}
\examples{
sample_gamma <- rpower(1000)
}
